/*
 * Decompiled with CFR 0.152.
 */
package com.aote.rs;

import com.aote.entity.EntityServer;
import com.aote.rs.SqlService;
import com.aote.rs.mapper.WebException;
import com.aote.sql.SqlServer;
import com.aote.util.ExcelUtil;
import com.aote.util.ExceptionHelper;
import com.aote.util.XMLReaderUtil;
import java.io.File;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import javax.sql.DataSource;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import org.apache.log4j.Logger;
import org.json.JSONArray;
import org.json.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Path(value="excel")
@Component
@Transactional
public class ExcelService {
    private static final Logger log = Logger.getLogger(SqlService.class);
    @Autowired
    private SqlServer sqlServer;
    @Autowired
    private DataSource dataSource;
    @Autowired
    private EntityServer entityServer;
    public static final int MAX_ROWS_PER_SHEET = 500001;

    @POST
    @Path(value="import/{entityname}")
    @Produces(value={"application/octet-stream"})
    public String importExcel(@PathParam(value="entityname") String entityname, String param) throws Exception {
        System.out.println(param);
        JSONObject json = new JSONObject(param);
        String filepath = (String)json.get("filepath");
        String configpath = (String)json.get("configpath");
        InputStream is = Files.newInputStream(new File(filepath).toPath(), new OpenOption[0]);
        filepath = filepath.replace("\\", "/");
        String fileName = filepath.split("/")[filepath.split("/").length - 1];
        if (!fileName.endsWith("xls") && !fileName.endsWith("xlsx")) {
            log.error((Object)(fileName + "\u4e0d\u662fexcel\u6587\u4ef6"));
            throw new WebException(500, fileName + "\u4e0d\u662fexcel\u6587\u4ef6");
        }
        System.out.println(fileName);
        JSONArray ja = new JSONArray();
        List<String[]> data = ExcelUtil.readExcel(is, fileName);
        XMLReaderUtil read = new XMLReaderUtil();
        Object[] field = read.getColumn(configpath, data.get(0));
        for (int i = 1; i < data.size(); ++i) {
            JSONObject jo = new JSONObject();
            int dataIndex = 0;
            for (int j = 0; j < field.length; ++j) {
                if (field[j] instanceof JSONObject) {
                    JSONObject children = (JSONObject)field[j];
                    for (String s : children.keySet()) {
                        JSONObject childrenjson = new JSONObject();
                        if (children.get(s) instanceof Object[]) {
                            Object[] obj = (Object[])children.get(s);
                            for (int z = 0; z < obj.length; ++z) {
                                childrenjson.put(obj[z].toString(), (Object)data.get(i)[j + dataIndex]);
                                if (z == obj.length - 1) continue;
                                ++dataIndex;
                            }
                        }
                        jo.put(s, (Object)childrenjson);
                    }
                    continue;
                }
                jo.put(field[j].toString(), (Object)data.get(i)[j + dataIndex]);
            }
            ja.put((Object)jo);
        }
        int len = ja.length();
        for (int i = 0; i < len; ++i) {
            JSONObject jo = ja.getJSONObject(i);
            System.out.println(jo);
            this.entityServer.partialSave(entityname, jo);
        }
        return "OK";
    }

    @POST
    @Path(value="report/{namedSql}/{excelTemplate}")
    @Produces(value={"application/octet-stream"})
    public String exportReportExcel(@PathParam(value="namedSql") String name, @PathParam(value="excelTemplate") String excelTemplate, String body) throws Exception {
        excelTemplate = "excel/" + excelTemplate + ".xlsx";
        log.debug((Object)("sql:" + name + ", template:" + excelTemplate + ", data:" + body));
        try {
            long tick = System.currentTimeMillis();
            String filePath = this.getFilePath();
            this.export(name, body, excelTemplate, filePath);
            tick = System.currentTimeMillis() - tick;
            log.fatal((Object)("\u8fdb\u884cExcel\u5bfc\u51fa\u8017\u65f6\uff1a" + (double)tick / 1000.0 + "\u79d2"));
            log.fatal((Object)("\u6587\u4ef6\u540d\uff1a" + filePath));
            return filePath;
        }
        catch (Exception e) {
            log.error((Object)ExceptionHelper.stackToString(e));
            throw e;
        }
    }

    @POST
    @Path(value="{name}")
    @Produces(value={"application/octet-stream"})
    public String exportExcel(@PathParam(value="name") String name, String body) throws Exception {
        log.debug((Object)("sql:" + name + ", data:" + body));
        try {
            long tick = System.currentTimeMillis();
            String filePath = this.getFilePath();
            this.export(name, body, null, filePath);
            tick = System.currentTimeMillis() - tick;
            log.fatal((Object)("\u8fdb\u884cExcel\u5bfc\u51fa\u8017\u65f6\uff1a" + (double)tick / 1000.0 + "\u79d2"));
            log.fatal((Object)("\u6587\u4ef6\u540d\uff1a" + filePath));
            return filePath;
        }
        catch (Exception e) {
            log.error((Object)ExceptionHelper.stackToString(e));
            throw e;
        }
    }

    private String getFilePath() {
        String excelFileName = UUID.randomUUID() + ".xlsx";
        String path = Objects.requireNonNull(ExcelUtil.class.getClassLoader().getResource("sql.xml")).getPath();
        String rootPath = path.split("WEB-INF")[0];
        return rootPath + "excel/" + excelFileName;
    }

    private void export(String name, String body, String templateName, String filePath) throws Exception {
        JSONObject joParam = new JSONObject(body);
        String[][] footer = null;
        if (joParam.has("total")) {
            JSONArray totals = joParam.getJSONArray("total");
            footer = this.getFooter(totals);
        }
        JSONObject joVariable = joParam.getJSONObject("data");
        String sql = new SqlServer().call(name, joVariable);
        try (Connection connection = this.dataSource.getConnection();
             PreparedStatement preparedStatement = connection.prepareStatement(sql);
             ResultSet rs = preparedStatement.executeQuery();){
            rs.setFetchSize(500001);
            if (templateName == null) {
                this.exportWithHedear(filePath, joParam, sql, rs, footer);
            } else {
                this.exportWithTemplate(templateName, sql, filePath, rs, footer);
            }
        }
    }

    private String[][] getFooter(JSONArray totals) {
        int n = totals.length();
        String[][] footer = new String[n][];
        for (int i = 0; i < n; ++i) {
            JSONObject jo = totals.getJSONObject(i);
            String[] names = JSONObject.getNames((JSONObject)jo);
            Arrays.sort(names, Comparator.comparingInt(Integer::parseInt));
            footer[i] = new String[names.length];
            for (int j = 0; j < names.length; ++j) {
                footer[i][j] = jo.isNull(names[j]) ? null : jo.get(names[j]) + "";
            }
        }
        return footer;
    }

    private void exportWithTemplate(String templateName, String sql, String filePath, ResultSet rs, String[][] footer) throws Exception {
        ExcelUtil eu = new ExcelUtil();
        eu.createBook(templateName, filePath);
        int nCol = rs.getMetaData().getColumnCount();
        int n = 1;
        ArrayList<List<Object>> rows = new ArrayList<List<Object>>();
        while (rs.next()) {
            if (n % 500001 == 0) {
                eu.createSheet();
                n = 1;
                eu.writeToSheet(rows, null, footer);
                rows = new ArrayList();
            }
            ArrayList<Object> fieldList = new ArrayList<Object>();
            for (int i = 1; i <= nCol; ++i) {
                Object object = rs.getObject(i);
                fieldList.add(object);
            }
            rows.add(fieldList);
            ++n;
        }
        if (n > 1) {
            eu.createSheet();
            eu.writeToSheet(rows, null, footer);
        }
        eu.saveBook();
    }

    private void exportWithHedear(String filePath, JSONObject joParam, String sql, ResultSet rs, String[][] footer) throws Exception, SQLException {
        boolean fromHbm = false;
        JSONObject joField = joParam.getJSONObject("field");
        LinkedHashMap<String, String> colsMap = new LinkedHashMap<String, String>();
        if (joField.has("xmlPath")) {
            this.findOutHeaders(joField.getString("xmlPath"), sql, colsMap);
            fromHbm = true;
        } else {
            this.findOutHeaders(joField, colsMap);
        }
        String[] header = colsMap.values().toArray(new String[0]);
        String[] cols = colsMap.keySet().toArray(new String[0]);
        ExcelUtil eu = new ExcelUtil();
        eu.createBook(null, filePath);
        int n = 1;
        ArrayList<List<Object>> rows = new ArrayList<List<Object>>();
        while (rs.next()) {
            int i;
            if (n % 500001 == 0) {
                eu.createSheet();
                n = 1;
                eu.writeToSheet(rows, header, footer);
                rows = new ArrayList();
            }
            ArrayList<Object> fieldList = new ArrayList<Object>();
            if (fromHbm) {
                fieldList.add(rs.getObject("id"));
            }
            int n2 = i = fromHbm ? 1 : 0;
            while (i < colsMap.size()) {
                Object object = rs.getObject(cols[i]);
                fieldList.add(object);
                ++i;
            }
            rows.add(fieldList);
            ++n;
        }
        if (n > 1) {
            eu.createSheet();
            eu.writeToSheet(rows, header, footer);
        }
        eu.saveBook();
    }

    private void findOutHeaders(JSONObject joField, Map<String, String> headers) {
        for (String col : joField.keySet()) {
            headers.put(col, joField.getString(col));
        }
    }

    private void findOutHeaders(String hbmFile, String sql, Map<String, String> headers) {
        LinkedHashMap<Object, Object> comment = new XMLReaderUtil().getCommont(hbmFile);
        headers.put("id", "\u7f16\u53f7");
        for (Object o : comment.keySet()) {
            String col = (String)o;
            headers.put(col, comment.get(col) + "");
        }
    }
}

