/*
 * Decompiled with CFR 0.152.
 */
package com.aote.redis;

import com.aote.config.SystemConfig;
import com.aote.rs.mapper.WebException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.log4j.Logger;
import org.json.JSONObject;
import org.redisson.Redisson;
import org.redisson.api.RBucket;
import org.redisson.api.RList;
import org.redisson.api.RLock;
import org.redisson.api.RMap;
import org.redisson.api.RTopic;
import org.redisson.api.RedissonClient;
import org.redisson.client.codec.Codec;
import org.redisson.client.codec.StringCodec;
import org.redisson.codec.FstCodec;
import org.redisson.codec.JsonJacksonCodec;
import org.redisson.codec.KryoCodec;
import org.redisson.codec.SerializationCodec;
import org.redisson.config.Config;
import org.redisson.config.SingleServerConfig;

public class RedisUtil {
    private static volatile RedisUtil redisUtil;
    private static final RedissonClient REDISSON_CLIENT;
    private static final Logger log;
    private static final Codec codec;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static RedisUtil getInstance() {
        if (redisUtil != null) return redisUtil;
        Class<RedisUtil> clazz = RedisUtil.class;
        synchronized (RedisUtil.class) {
            if (redisUtil != null || REDISSON_CLIENT == null) return redisUtil;
            redisUtil = new RedisUtil();
            // ** MonitorExit[var0] (shouldn't be in output)
            return redisUtil;
        }
    }

    private RedisUtil() {
    }

    public <T> void set(String key, T value, Codec codec) {
        RBucket rBucket = REDISSON_CLIENT.getBucket(key, codec);
        rBucket.set(value);
    }

    public <T> void set(String key, T value) {
        this.set(key, value, -1L);
    }

    public <T> void set(String key, T value, long timeoutSec) {
        RBucket rBucket = REDISSON_CLIENT.getBucket(key, codec);
        if (timeoutSec > 0L) {
            rBucket.set(value, timeoutSec, TimeUnit.SECONDS);
        } else {
            rBucket.set(value);
        }
    }

    public <T> RList<T> getRedisList(String key) {
        return REDISSON_CLIENT.getList(key);
    }

    public <K, V> RMap<K, V> getRedisMap(String key) {
        return REDISSON_CLIENT.getMap(key);
    }

    public List<Object> getList(String key) {
        return REDISSON_CLIENT.getList(key, codec).readAll();
    }

    public <T> void setList(String key, List<T> value) {
        this.setList(key, value, -1L);
    }

    public <T> void setList(String key, List<T> value, long timeoutSec) {
        RList rList = REDISSON_CLIENT.getList(key, codec);
        rList.addAll(value);
        if (timeoutSec > 0L) {
            rList.expire(timeoutSec, TimeUnit.SECONDS);
        }
    }

    public <T> void setListKey(String key, T value) {
        RList list = REDISSON_CLIENT.getList(key, codec);
        list.add(value);
    }

    public <T> void setAllListKey(String key, List<T> value) {
        RList list = REDISSON_CLIENT.getList(key, codec);
        list.addAll(value);
    }

    public void deleteList(String key) {
        REDISSON_CLIENT.getList(key, codec).delete();
    }

    public void clearList(String key) {
        REDISSON_CLIENT.getList(key, codec).clear();
    }

    public void deleteListKeyByIndex(String key, Integer index) {
        REDISSON_CLIENT.getList(key, codec).remove((Object)index);
    }

    public void deleteListKeyByObject(String key, Object object) {
        REDISSON_CLIENT.getList(key, codec).remove(object);
    }

    public void setHash(String hashKey, JSONObject value) {
        this.setHash(hashKey, value.toMap());
    }

    public <T> void setHash(String hashKey, Map<String, T> value) {
        this.setHash(hashKey, value, -1L);
    }

    public <T> void setHash(String hashKey, Map<String, T> value, long timeoutSec) {
        RMap rMap = REDISSON_CLIENT.getMap(hashKey, codec);
        rMap.putAll(value);
        if (timeoutSec > 0L) {
            rMap.expire(timeoutSec, TimeUnit.SECONDS);
        }
    }

    public Map<Object, Object> getHash(String hashKey) {
        return REDISSON_CLIENT.getMap(hashKey, codec).readAllMap();
    }

    public <T> T getHash(String hashKey, String key) {
        RMap map = REDISSON_CLIENT.getMap(hashKey, codec);
        return (T)map.get(key);
    }

    public <T> void setHashKey(String hashKey, String key, T value) {
        RMap map = REDISSON_CLIENT.getMap(hashKey, codec);
        map.put(key, value);
    }

    public void deleteHash(String hashKey) {
        REDISSON_CLIENT.getMap(hashKey, codec).delete();
    }

    public void clearHash(String hashKey) {
        REDISSON_CLIENT.getMap(hashKey, codec).clear();
    }

    public void deleteHashKey(String hashKey, String key) {
        REDISSON_CLIENT.getMap(hashKey, codec).remove((Object)key);
    }

    public Boolean hasHashKey(String hashKey, String key) {
        return REDISSON_CLIENT.getMap(hashKey, codec).containsKey((Object)key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void lock(String key, Runnable runnable) {
        block7: {
            RLock lock = REDISSON_CLIENT.getLock("LOCK-" + key);
            try {
                boolean isLock = lock.tryLock(10L, 20L, TimeUnit.SECONDS);
                if (isLock) {
                    runnable.success();
                    break block7;
                }
                throw new WebException(505, "\u4fee\u6539\u5931\u8d25\uff0c\u8be5\u6570\u636e\u53d7\u9501\u4fdd\u62a4\u4e2d\u3002");
            }
            catch (InterruptedException e) {
                log.error((Object)("\u5206\u5e03\u5f0f\u9501" + lock.getName() + "\u83b7\u53d6\u5931\u8d25"));
                e.printStackTrace();
            }
            finally {
                if (lock.isHeldByCurrentThread()) {
                    lock.unlock();
                }
            }
        }
    }

    public <T> T get(String key) {
        RBucket bucket = REDISSON_CLIENT.getBucket(key, codec);
        return (T)bucket.get();
    }

    public <T> T get(String key, Codec codec) {
        RBucket bucket = REDISSON_CLIENT.getBucket(key, codec);
        return (T)bucket.get();
    }

    public void delete(String key) {
        REDISSON_CLIENT.getBucket(key, codec).delete();
    }

    public void deleteList(Iterable<Object> keys) {
        keys.forEach(item -> this.delete(String.valueOf(item)));
    }

    public void deleteList(JSONObject keys) {
        this.deleteList(new ArrayList<Object>(keys.keySet()));
    }

    public RTopic getTopic(String topicName) {
        return REDISSON_CLIENT.getTopic(topicName, codec);
    }

    static {
        log = Logger.getLogger(RedisUtil.class);
        if (SystemConfig.Redis.hasHostName()) {
            Config config = new Config();
            if (SystemConfig.Redis.hasCodecType()) {
                switch (SystemConfig.Redis.getCodecType()) {
                    case "Jackson": {
                        codec = new JsonJacksonCodec();
                        break;
                    }
                    case "Serialization": {
                        codec = new SerializationCodec();
                        break;
                    }
                    case "String": {
                        codec = new StringCodec();
                        break;
                    }
                    case "Fst": {
                        codec = new FstCodec();
                        break;
                    }
                    case "Kryo": {
                        codec = new KryoCodec();
                        break;
                    }
                    default: {
                        throw new RuntimeException("\u4e0d\u652f\u6301\u7684\u5e8f\u5217\u5316\u65b9\u5f0f\uff1a" + SystemConfig.Redis.getCodecType());
                    }
                }
            } else {
                codec = new JsonJacksonCodec();
            }
            config.setCodec(codec);
            SingleServerConfig singleServerConfig = config.useSingleServer();
            singleServerConfig.setAddress("redis://" + SystemConfig.Redis.getHostName());
            if (SystemConfig.Redis.hasPassword()) {
                singleServerConfig.setPassword(SystemConfig.Redis.getPassword());
            }
            REDISSON_CLIENT = Redisson.create((Config)config);
            log.info((Object)"***redis\u5b9e\u4f8b\u5df2\u52a0\u8f7d\u5b8c\u6210***");
        } else {
            codec = null;
            REDISSON_CLIENT = null;
            log.warn((Object)"***redis\u5b9e\u4f8b\u672a\u914d\u7f6e***");
        }
    }

    @FunctionalInterface
    public static interface Runnable {
        public void success();
    }
}

