package com.aote.rs;

import com.aote.transaction.SessionPool;
import javassist.NotFoundException;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;

@Path("trans")
@Component
public class TransactionService {
    static final Logger log = Logger.getLogger(TransactionService.class);

    @Autowired
    private SessionPool sessionPool;

    /**
     * 取session，并开始事务
     * @return session号
     * @throws NotFoundException
     */
    @GET
    public int getSession() throws NotFoundException {
        int result = this.sessionPool.createSession();
        log.debug("活动session，i=" + result);
        return result;
    }

    /**
     * 提交事务
     * @param i 要提交的事务的session编号
     */
    @GET
    @Path("commit/{i}")
    public String commit(@PathParam("i") int i) {
        sessionPool.commit(i);
        return "";
    }

    /**
     * 回滚事务
     * @param i 要回滚的事务编号
     */
    @GET
    @Path("rollback/{i}")
    public String rollback(@PathParam("i") int i) {
        sessionPool.rollback(i);
        return "";
    }
}
