/*
 * Decompiled with CFR 0.152.
 */
package com.aote.rs;

import com.aote.path.PathMapper;
import com.aote.path.PathServer;
import com.aote.util.ExceptionHelper;
import com.aote.util.Util;
import com.aote.util.other.AESUtil;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import org.apache.log4j.Logger;
import org.json.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Path(value="path")
@Component
@Transactional
public class PathService {
    static final Logger log = Logger.getLogger(PathService.class);
    @Autowired
    private PathServer pathServer;

    @POST
    @Path(value="{name}/n")
    public String txgetTotalCnt(@PathParam(value="name") String name, String str, @Context HttpServletRequest request) throws Exception {
        try {
            str = Util.aesWhiteList(request, str);
            return this.pathEncrypt(name, str, false, new int[0]);
        }
        catch (Exception ex) {
            log.error((Object)ExceptionHelper.stackToString(ex));
            throw ex;
        }
    }

    @POST
    @Path(value="{name}")
    public String txPath(@PathParam(value="name") String name, @QueryParam(value="pageNo") int pageNo, @QueryParam(value="pageSize") int pageSize, String str, @Context HttpServletRequest request) throws Exception {
        try {
            String level = PathMapper.getAttr(name, "log");
            if (level != null) {
                log.info((Object)(name + ":" + str));
            }
            str = Util.aesWhiteList(request, str);
            String ret = this.pathEncrypt(name, str, true, pageNo, pageSize);
            if (level != null) {
                log.info((Object)(name + ":" + ret));
            }
            return ret;
        }
        catch (Exception ex) {
            log.error((Object)ExceptionHelper.stackToString(ex));
            throw ex;
        }
    }

    public String pathEncrypt(String pathName, String param, boolean isQuery, int ... values) throws Exception {
        JSONObject paramJson = new JSONObject(param);
        return AESUtil.encryptData(paramJson, "rs/path/" + pathName, data -> isQuery ? this.pathServer.query(pathName, values[0], values[1], data).toString() : this.pathServer.queryTotal(pathName, data).toString());
    }
}

