package com.aote.util;

import com.aote.timer.BankBalanceAccountSource;
import org.json.JSONObject;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;

public class FileReaderUtil {

	public static JSONObject readJSONFile(String fileName) {
		BufferedReader reader = null;
		StringBuilder jsonStr = new StringBuilder();
		try {
			InputStream resourceAsStream = BankBalanceAccountSource.class.getResourceAsStream("/" + fileName);
			InputStreamReader inputStreamReader = new InputStreamReader(resourceAsStream, StandardCharsets.UTF_8);
			reader = new BufferedReader(inputStreamReader);
			String temp;
			while ((temp = reader.readLine()) != null) {
				jsonStr.append(temp);
			}
			reader.close();
		} catch (IOException e) {
			e.printStackTrace();
		} finally {
			if (reader != null) {
				try {
					reader.close();
				} catch (IOException e) {
					e.printStackTrace();
				}
			}
		}
		return new JSONObject(jsonStr.toString());
	}

}
