package com.aote.filter;

import com.aote.config.Config;
import org.apache.log4j.Logger;
import org.springframework.web.filter.OncePerRequestFilter;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/**
 * @Author: JoeCdy
 * @Description: 响应体修改
 * @Date: Created in 16:02 2023/4/13
 */
public class ResponseFilter extends OncePerRequestFilter {

    static Logger log = Logger.getLogger(ResponseFilter.class);

    private static String redispwd;

    public static String regex = "\\|-\\S*?(==|=)-\\|";

    @Override
    protected void doFilterInternal(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, FilterChain filterChain) throws ServletException, IOException {
        // 开始时间
        Long startTime = System.currentTimeMillis();
        ServletOutputStream out = null;
        String url = httpServletRequest.getRequestURI();
        if (!Config.filterCheck(url)) {
            filterChain.doFilter(httpServletRequest, httpServletResponse);
        } else {
            // 需要解敏感操作, 开始替换响应数据
            try {
                ModifyResponseBodyWrapper modifyResponseBodyWrapper = new ModifyResponseBodyWrapper(httpServletResponse);
                filterChain.doFilter(httpServletRequest, modifyResponseBodyWrapper);
                // 修改response的body
                String oldResponseBody = modifyResponseBodyWrapper.getResponseBody();
                Pattern pattern = Pattern.compile(regex);
                Matcher matcher = pattern.matcher(oldResponseBody);
                // 用户id
                String loginId = httpServletRequest.getHeader("Token");
                boolean authorization = Config.isAuthorization(loginId);
                log.debug("当前用户:" + loginId + ",解敏权限:" + authorization);
                // 匹配到并且有解敏权限
                String newResponseBody = modifyResponseBody(oldResponseBody, matcher.find() && authorization);
                // 响应编码
                httpServletResponse.setContentLength(newResponseBody.getBytes(StandardCharsets.UTF_8).length);
                httpServletResponse.setContentType(httpServletRequest.getContentType());
                byte[] responseBodyData = newResponseBody.getBytes(StandardCharsets.UTF_8);
                out = httpServletResponse.getOutputStream();
                out.write(responseBodyData);
                out.flush();
                Long endTime = System.currentTimeMillis();
                log.debug("ResponseFilter:" + url + ",拦截器耗时:" + (endTime - startTime));
            } catch (Exception e) {
                log.error("ResponseFilter拦截器异常:", e);
                throw e;
            } finally {
                if (out != null) {
                    out.close();
                }
            }
        }
    }

    /**
     * 响应体修改
     *
     * @param originalBody 原始数据
     * @param sensitive    是否真实敏感数据
     * @return 修改后的数据
     */
    public static String modifyResponseBody(String originalBody, Boolean sensitive) {
        // 根据需要进行修改
        Pattern pattern = Pattern.compile(regex);
        Matcher matcher = pattern.matcher(originalBody);
        StringBuffer sb = new StringBuffer(originalBody.length());
        String replacement = "****";
        while (matcher.find()) {
            String match = matcher.group(0);
            if (sensitive) {
                // 解密
                try {
                    replacement = RSAUtil.aesDecrypt(match.replace("|-", "").replace("-|", ""), DesensitizationTool.KEY);
                } catch (Exception e) {
                    log.debug("解密异常", e);
                    throw new RuntimeException(e);
                }
            }
            matcher.appendReplacement(sb, replacement);
        }
        matcher.appendTail(sb);
        return sb.toString();
    }

}
