package com.aote.util;

import com.aote.config.SystemConfig;
import org.json.JSONObject;

import com.aote.rs.mapper.WebException;

/**
 * 为业务逻辑提供各种辅助功能
 * @author he
 */
public class Util {
	/**
	 * 抛异常
	 */
	public void error(JSONObject param) {
		int status = Integer.parseInt(param.get("status").toString());
		String msg = (String)param.get("msg");
		throw new WebException(status, msg);
	}

	/**
	 * 加密验证
	 * @param params 请求数据
	 */
	public static void checkEncry(JSONObject params){
		if (!params.has("aoteEncrypt") && SystemConfig.DataSecurity.getEnableDataEncryption()){
			throw new RuntimeException("数据要求强制加密！");
		}
	}
}
