package com.aote.util;

import com.alibaba.fastjson.JSON;
import com.aote.util.other.JsonTools;
import org.json.JSONArray;
import org.json.JSONObject;

import java.util.*;

/**
 * @author WangZeSong
 * @date 2019-5-9 am 10:35
 */
public class StringUtil {

    /**
     * 判断字符串非空（2个条件）：
     *     1.引用非空-null
     *     2.非空字符串-" "
     * */
    public static boolean hasLength(String str){
        return str!=null && !"".equals(str.trim());
    }

    /**
     * 判断字符串为空
     */
    public static boolean isBlank(String str){
        return !hasLength(str);
    }

    /**
     * 将List数组转换成jsonarray
     */
    public static JSONArray listToJsonArray(List<Object> list) {
        return new JSONArray(list);
    }

    /**
     * 将jsonarray转成ArrayList
     * */
    public static List<String> jsonArrayToList(JSONArray jsonArray) {
        return JSON.parseArray(jsonArray.toString(),String.class);
    }


    /**
     * 将jsonarray转成ArrayList
     * */
    public static List<Object> jsonArrayToLists(JSONArray jsonArray) {
        return JSON.parseArray(jsonArray.toString(),Object.class);
    }

    /**
     * 将map转换为jsonObject
     *
     * */
    public static JSONObject mapToJsonObject(Map<Object,Object> map) {
        return new JSONObject(map);
    }

    /**
     * 将jsonobject转换为map
     *
     * */
    public static Map<String, Object> jsonObjectToMap(JSONObject jsonObject) {
        return JsonTools.toHashMap(jsonObject);
    }

    /**
     * @param jsonArray 传进来的参数对象微JSONArray类型的
     * @describe 如果参数的长度大于0，则遍历这个jsonarray数组，将每一个元素添加到HashSet中，然后返回这个HashSet
     *
     * */
    public static Set jsonArrayToSet(JSONArray jsonArray) {
        Set<JSONObject> set = new HashSet<>();
        if (jsonArray.length() > 0) {
            for (int i = 0; i < jsonArray.length(); i++) {
                JSONObject jsonObject = jsonArray.getJSONObject(i);
                set.add(jsonObject);
            }
        }
        return set;
    }

    /**
     * @param set 传进来的参数对象为Set集合类型
     * @describe 遍历这个HashSet集合，将每一个元素添加到jsonarray数组中，返回这个jsonarray数组
     * */
    public static JSONArray setToJSONArray(Set set) {
        JSONArray jsonArray = new JSONArray();
        for (Object object : set) {
            jsonArray.put(String.valueOf(object));
        }
        return jsonArray;
    }

    /**
     * 将字符串转换为布尔值的方法
     * */
    public static boolean stringToboolean(String string) {
        return Boolean.valueOf(string);
    }

    /**
     * 将布尔值转换为字符串的方法
     * */
    public static String booleanToString(boolean tf) {
        return String.valueOf(tf);
    }

    /**
     * 将字符串转换为Long的方法
     * */
    public static Long stringToLong(String string) {
        return Long.valueOf(string);
    }

    /**
     * 将字符串转换为Integer的方法
     * */
    public static Integer stringToInteger(String string) {
        return Integer.valueOf(string);
    }

    /**
     * 将Integer转换为字符串的方法
     * */
    public static String integerToString(Integer integer) {
        return String.valueOf(integer);
    }

    /**
     * 将字符串转换为byte[]的方法
     * */
    public static byte[] stringTobytes(String string) {
        return string.getBytes();
    }

    /**
     * 将byte[]转换为字符串的方法
     * */
    public static String bytesToString(byte[] bytes) {
        return Arrays.toString(bytes);
    }
}
