package com.aote.rs;

import com.aote.entity.EntityServer;
import com.aote.exception.ExceptionLogManage;
import com.aote.util.ExceptionHelper;
import com.aote.util.JsonHelper;
import com.aote.util.ParamFilter;
import com.aote.util.Util;
import com.aote.util.other.AESUtil;
import org.apache.log4j.Logger;
import org.json.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

import javax.annotation.PostConstruct;
import javax.inject.Singleton;
import javax.ws.rs.DELETE;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;

@Path("entity")
@Singleton
@Component
@Transactional
public class EntityService {
	static Logger log = Logger.getLogger(EntityService.class);

	@Autowired
	private EntityServer entityServer;

	@Autowired
	private ExceptionLogManage exceptionLogManage;

	@POST
	@Path("{entity}")
	// 保存实体
	public String xtSave(@PathParam("entity") String entityName, String values)
			throws Exception {
		try {
			return entityEncrypt(entityName, values);
		} catch (Exception ex) {
			log.error(ExceptionHelper.stackToString(ex));
			exceptionLogManage.writeError(ex,entityName,"/rs/entity/"+entityName,values);
			throw ex;
		}
	}

	@DELETE
	@Path("{entity}/{id}")
	// 删除实体
	public String txDelete(@PathParam("entity") String entityName,
						   @PathParam("id") String id) throws Exception {
		try {
			return entityServer.delete(entityName, id);
		} catch (Exception ex) {
			log.error(ExceptionHelper.stackToString(ex));
			exceptionLogManage.writeError(ex,entityName,"/rs/entity/"+entityName+"/"+id,null);
			throw ex;
		}
	}

	/**
	 * 封装entity加解密
	 * @param entityName 实体名
	 * @param param	请求参数
	 * @return
	 * @throws Exception
	 */
	private String entityEncrypt(String entityName, String param) throws Exception{
		JSONObject paramJson = new JSONObject(param);
		return AESUtil.encryptData(paramJson,
				(data) -> entityServer.partialSave(entityName, data));
	}

	@PostConstruct
	public void init() {
		entityServer.loadMetaData();
	}
}
