package com.aote.filter;

import com.aote.ThreadResource;

import com.aote.config.SystemConfig;
import com.aote.rs.ManagerService;
import com.aote.util.other.JwtTools;
import com.aote.util.other.RestTools;
import io.jsonwebtoken.Claims;
import org.apache.log4j.Logger;
import org.json.JSONObject;

import javax.servlet.*;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import java.io.IOException;

public class LoginFilter implements Filter {
    static Logger log = Logger.getLogger(LoginFilter.class);

    /**
     * 从cookie里获取给定主键的内容
     * @param key
     * @return
     */
    private String getCookie(HttpServletRequest request, String key) {
        Cookie[] cookies = request.getCookies();
        if (cookies == null) {
            return null;
        }
        for(Cookie cookie : request.getCookies()) {
            if (cookie.getName().equals(key)) {
                return cookie.getValue();
            }
        }
        return null;
    }

    @Override
    public void init(FilterConfig filterConfig) throws ServletException {
    }

    @Override
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        // 清除线程变量
        ThreadResource.LoginUser.set(null);
        ThreadResource.ComponentDir.set(null);
        ThreadResource.Token.set(null);
        HttpServletRequest req =(HttpServletRequest) request;

        // 从请求头获取sessionid
        String sessionId = req.getHeader("session");
        ThreadResource.SessionId.set(sessionId == null ? null : Integer.valueOf(sessionId));

        // 从请求头获取公司目录配置
        String componentDir = req.getHeader("componentDir");
        log.debug("获取的componentDir" + componentDir);
        // 如果有公司目录配置，不管人，直接把公司目录放到线程变量里
        if (componentDir != null) {
            ThreadResource.ComponentDir.set(componentDir);
            chain.doFilter(request, response);
            return;
        }

        // 从请求头中获取Token
        String Token = req.getHeader("Token");
        log.debug("获取的Token"+Token);
        if (Token == null) {
            chain.doFilter(request, response);
            return;
        }
        // 把token传递下去
        ThreadResource.Token.set(Token);

        //解析Token
        try {
            JwtTools jt = new JwtTools();
            Claims claims =jt.parseJWT(Token);
            //获取Token中用户id
            String loginId = (String) claims.get("userid");
            log.debug("loginId=" + loginId);
            if (loginId == null) {
                chain.doFilter(request, response);
                return;
            }
            // 得到ldap服务地址，将通过ldap服务添加功能
            if (SystemConfig.System.hasLdapUrl()) {
                log.error("systemConfig.json无ldap配置");
                return;
            }
            String ldap = SystemConfig.System.getLdapUrl();
            // 根据用户id从ldap中获取业务逻辑等内容存放路径
            String str = RestTools.post(ldap+"/rs/search", "{source:'this.getInfo()',userid:'" + loginId + "'}");
            log.debug("用户信息：" + str);
            JSONObject json = new JSONObject(str);
            // 把用户完整信息存放到线程变量里
            ThreadResource.LoginUser.set(json);

            String res = json.getString("dir");
            log.debug("组件目录：" + res);
            if (res != null && !"null".equals(res)) {
                // 把存放路径放到线程变量中，供其他地方调用
                ThreadResource.ComponentDir.set(res);
            }
            log.debug("-----请求地址："+req.getRequestURI()+"-----");
			log.debug("进入chain.doFilter");
			chain.doFilter(request, response);
			log.debug("出入chain.doFilter");
        } catch (ServletException e) {
            log.error("拦截器日志ServletException：",e);
            throw e;
        } catch (Throwable e) {
            log.error("拦截器日志Throwable：",e);
            throw new ServletException("获取用户信息错误，Token=" + Token, e);
        }
   }

    @Override
    public void destroy() {
    }
}
