package com.aote.config;

import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.PropertiesConfiguration;
import org.apache.commons.configuration.reloading.FileChangedReloadingStrategy;
import org.apache.log4j.Logger;

import java.util.Arrays;

/**
 * 读取配置文件
 */
public class Config {
    static Logger log = Logger.getLogger(Config.class);

    /**
     *  参数对象, 用它动态获取数据
     */
    public static PropertiesConfiguration config;

    static {
        try {
            config = new PropertiesConfiguration("Config.properties");
            // 自动重新加载
            config.setReloadingStrategy(new FileChangedReloadingStrategy());
        } catch (ConfigurationException e) {
            e.printStackTrace();
        }
    }

    public static boolean isPassUri(String url) {
        for (String item : config.getString("jwtPass").split("-")) {
            if (url.contains(item)) {
                return true;
            }
        }
        return false;
    }
}
