package com.aote.util;

import com.aote.rs.mapper.WebException;
import com.aote.util.other.RestTools;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.util.EntityUtils;
import org.json.JSONObject;

/**
 * ldap访问辅助类
 */
public class LdapHelper {

    /**
     * 调用ldap的search服务
     * @param url: ldap的url
     * @param str: search表达式
     */
    public static String search(String url, String str) throws Exception {
        String path = url + "/rs/search";
        String result = RestTools.post(path, str);
        // 出错，抛出web异常
        if (result.contains("errorEntity")) {
            JSONObject error = new JSONObject(result);
            throw new WebException(error.getInt("status"), str);
        }
        return result;
    }

    /**
     * 给节点增加子节点, 如果属性中有id，表示更新
     * @param url
     * @param data
     * @return
     */
    public static String saveChild(String url, String parentid, JSONObject data) throws Exception  {
        // 把父节点添加到子节点属性中
        data.put("parentid", parentid);
        // 组织服务所需json结构
        JSONObject param = new JSONObject();
        param.put("data",  data);

        String path = url + "/rs/data/save";

        String result = RestTools.post(path, param);
        // 出错，抛出web异常
        if (result.contains("errorEntity")) {
            JSONObject error = new JSONObject(result);
            throw new WebException(error.getInt("status"), result);
        }
        return result;
    }
}
