package com.aote.path;

import com.aote.rs.mapper.WebException;
import org.apache.http.HttpResponse;
import org.apache.http.ParseException;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.util.EntityUtils;

import java.io.*;
import java.util.Arrays;

public class PathTestCase{
	public void analysis(String fileName) {
		String str;
		String path =null;
		String parameter;
		String expected;
		String result = "";
			try {
				String sourceName = "/" + fileName;
				InputStream bis = this.getClass().getResourceAsStream(sourceName);
				Reader reader = new InputStreamReader(bis);
				BufferedReader buffer = new BufferedReader(reader);
				//读取指定文件
				while ((str = buffer.readLine())!=null ) {
					//读取测试路径
				if(str.contains("post")){
					String[] newArray = str.split(" ");
					 path =newArray[1];
				}
				if(str.contains("{")){
					//读取方法参数
				 parameter = read(buffer);
				 	//执行方法
				 result = start(path,parameter);
				}
				//读取预期结果
				if(str.contains("expected")){
					String[] exArray =str.split(" ");
					expected = exArray[1];
					String[] strArray = expected.split(",");
					//打印读取信息
						System.out.println(Arrays.toString(strArray));
						 for(String s:strArray){
							 if(!result.contains(s)){
								 throw new RuntimeException("结果中缺失:"+s);
							 }
						 }
					}
				}
			} catch (IOException e) {
				throw new WebException(500, "您所测试的方法不存在!!!请检查路径");
			}
	}
	//读取方法参数
	private String read(BufferedReader buffer) {
		String str;
		String newParameter = null;
		StringBuilder StrParameter = new StringBuilder();
		try {
			while ((str = buffer.readLine())!=null ) {
				StrParameter.append(str);
				if(str.startsWith("}")){
					break;	
				}
			}
			newParameter = StrParameter.substring(0,StrParameter.length());
			 newParameter = "{data: {"+newParameter +"}";
		} catch (IOException e) {
			e.printStackTrace();
		}
		return newParameter;
	}
	
	//测试方法调用
	public String start(String path,String parameter){
		String actual = null;
		String realPath=path.replace("+", "%20");
		System.out.println("path: "+path);
		System.out.println("parameter: "+parameter);

		//执行被测试方法
		HttpPost postMethod =new HttpPost(realPath);
		StringEntity se;
		try {
			se = new StringEntity(parameter, "UTF-8");
			postMethod.setEntity(se);
		// 发送Post请求
			HttpClient httpClient = new DefaultHttpClient();
			HttpResponse response;
			response = httpClient.execute(postMethod);
			actual = EntityUtils.toString(response.getEntity(), "UTF8");
			System.out.println("result:"+actual);
			int code = response.getStatusLine().getStatusCode();
			if(code != 200){
				throw new RuntimeException("服务返回错误码:"+code);
			}
		} catch (ParseException | IOException e) {
			e.printStackTrace();
		}
		return actual;
	}} 
