/*
 * Decompiled with CFR 0.152.
 */
package com.aote.queryparams;

import com.aote.entity.EntityServer;
import com.aote.queryparams.DataMode;
import com.aote.queryparams.enums.AddOrEditTypeEnum;
import com.aote.queryparams.enums.ColumnFixedTypeEnum;
import com.aote.queryparams.enums.DataModeEnum;
import com.aote.queryparams.enums.FormTypeEnum;
import com.aote.queryparams.enums.QueryTypeEnum;
import com.aote.queryparams.enums.RuleTypeEnum;
import com.aote.queryparams.enums.SilencePurposeEnum;
import com.aote.queryparams.enums.SlotTypeEnum;
import com.aote.rs.mapper.WebException;
import com.aote.util.ResourceHelper;
import com.aote.util.ResourceType;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Iterator;
import org.apache.log4j.Logger;
import org.json.JSONArray;
import org.json.JSONObject;
import org.springframework.stereotype.Component;

@Component
public class QueryParamsServer {
    private static final Logger LOGGER = Logger.getLogger(QueryParamsServer.class);

    public static JSONObject getQueryParamsInfo(String source) {
        String conditionStr;
        JSONObject realQueryParamsMap = new JSONObject(source);
        if (realQueryParamsMap.has("group")) {
            return QueryParamsServer.getSimpleFormInfo(realQueryParamsMap);
        }
        StringBuilder sql = new StringBuilder("SELECT ");
        StringBuilder countSql = new StringBuilder("SELECT COUNT(0) n");
        String tableName = realQueryParamsMap.getString("tableName");
        String tableAliasName = tableName.substring(tableName.indexOf(32) + 1);
        JSONObject joinTableNameObject = realQueryParamsMap.getJSONObject("joinArray");
        JSONObject buttonState = realQueryParamsMap.has("buttonState") ? realQueryParamsMap.getJSONObject("buttonState") : null;
        JSONArray queryColumnArray = realQueryParamsMap.getJSONArray("column");
        JSONArray canJoinTableNameObject = new JSONArray();
        JSONObject selectColumnArray = new JSONObject();
        JSONArray showColumnArray = new JSONArray(queryColumnArray.length());
        JSONArray formItemArray = new JSONArray(queryColumnArray.length());
        for (Object columnItem : queryColumnArray) {
            AddOrEditTypeEnum addOrEditTypeEnum;
            FormTypeEnum formTypeEnum;
            DataMode dataModeObject;
            JSONArray dataModeArray;
            JSONObject column = (JSONObject)columnItem;
            String key = column.getString("key");
            int index = key.indexOf(46);
            index = index == -1 ? 0 : ++index;
            String realKey = key.substring(index);
            String columnAliasName = null;
            JSONArray jSONArray = dataModeArray = column.has("dataModeArray") ? column.getJSONArray("dataModeArray") : null;
            if (dataModeArray == null) {
                DataModeEnum dataModeEnum;
                if (!column.has("dataMode")) {
                    dataModeEnum = DataModeEnum.ALL;
                } else {
                    String dataMode = column.getString("dataMode");
                    dataModeEnum = DataModeEnum.toType(dataMode);
                    if (dataModeEnum == null) {
                        throw new WebException(500, "\u5217[" + key + "]\u65e0\u6cd5\u88ab\u5904\u7406\uff0c\u56e0\u4e3a\u8fd9\u4e2a\u6570\u636e\u6a21\u5f0f\u4e0d\u5b58\u5728\uff1a" + dataMode);
                    }
                }
                dataModeObject = dataModeEnum.getDataMode();
            } else {
                boolean queryForm = false;
                boolean table = false;
                boolean addOrEditForm = false;
                boolean sqlQueryItem = false;
                boolean sqlQueryCondition = false;
                block28: for (Object item : dataModeArray) {
                    switch ((String)item) {
                        case "queryForm": {
                            queryForm = true;
                            continue block28;
                        }
                        case "table": {
                            table = true;
                            continue block28;
                        }
                        case "addOrEditForm": {
                            addOrEditForm = true;
                            continue block28;
                        }
                        case "sqlQueryItem": {
                            sqlQueryItem = true;
                            continue block28;
                        }
                    }
                    sqlQueryCondition = true;
                }
                dataModeObject = new DataMode(queryForm, table, addOrEditForm, sqlQueryItem, sqlQueryCondition);
            }
            if (dataModeObject.isSqlQueryItem()) {
                String columnName;
                String joinTableAlias = key.substring(0, key.indexOf(46));
                columnAliasName = joinTableAlias + "_" + realKey;
                if (column.has("default")) {
                    String dialect = EntityServer.findDialect();
                    String defaultValue = String.valueOf(column.get("default"));
                    switch (dialect) {
                        default: {
                            columnName = "ISNULL(" + key + ",'" + defaultValue + "') " + columnAliasName;
                            break;
                        }
                        case "MySQL": {
                            columnName = "IFNULL(" + key + ",'" + defaultValue + "') " + columnAliasName;
                            break;
                        }
                        case "Oracle": {
                            columnName = "NVL(" + key + ",'" + defaultValue + "') " + columnAliasName;
                            break;
                        }
                    }
                } else {
                    columnName = key + " " + columnAliasName;
                }
                sql.append("\n\t").append(columnName).append(",");
                QueryParamsServer.putJoinCondition(joinTableAlias, tableAliasName, joinTableNameObject, canJoinTableNameObject, false);
            }
            if (dataModeObject.isSqlQueryCondition()) {
                QueryTypeEnum queryTypeEnum;
                if (column.has("queryType")) {
                    String queryType = column.getString("queryType");
                    queryTypeEnum = QueryTypeEnum.toType(queryType);
                    if (queryTypeEnum == null) {
                        throw new WebException(500, "\u5217[" + key + "]\u65e0\u6cd5\u751f\u6210\u8868\u5355\u9879\uff0c\u56e0\u4e3a\u8fd9\u4e2a\u8868\u5355\u67e5\u8be2\u7c7b\u578b\u4e0d\u5b58\u5728\uff1a" + queryType);
                    }
                } else {
                    queryTypeEnum = QueryTypeEnum.EQUALS;
                }
                JSONObject selectColumnItem = new JSONObject();
                selectColumnItem.put("queryType", (Object)queryTypeEnum.getValue());
                selectColumnItem.put("key", (Object)key);
                selectColumnArray.put(key, (Object)selectColumnItem);
            }
            if (dataModeObject.isTable()) {
                JSONObject slot;
                JSONObject item = new JSONObject();
                item.put("title", (Object)column.getString("title"));
                item.put("dataIndex", (Object)(columnAliasName == null ? realKey : columnAliasName));
                int width = 0;
                if (!column.has("slot")) {
                    slot = new JSONObject();
                    slot.put("type", (Object)"ellipsis");
                    slot.put("value", 16);
                } else {
                    slot = column.getJSONObject("slot");
                }
                JSONObject scopedSlots = new JSONObject();
                scopedSlots.put("customRender", (Object)(columnAliasName == null ? realKey : columnAliasName));
                item.put("scopedSlots", (Object)scopedSlots);
                item.put("slots", (Object)scopedSlots);
                if (slot.has("type")) {
                    String slotType = slot.getString("type");
                    SlotTypeEnum slotTypeEnum = SlotTypeEnum.toType(slotType);
                    if (slotTypeEnum == null) {
                        throw new WebException(500, "\u5217[" + key + "]\u65e0\u6cd5\u9002\u7528\u63d2\u69fd\uff0c\u56e0\u4e3a\u8fd9\u4e2a\u63d2\u69fd\u7c7b\u578b\u4e0d\u5b58\u5728\uff1a" + slotType);
                    }
                    item.put("slotType", (Object)slotType);
                    switch (slotTypeEnum) {
                        case DATE_TIME: {
                            width = 160;
                            break;
                        }
                        case ELLIPSIS: {
                            int ellipsisValue = slot.getInt("value");
                            BigDecimal b = new BigDecimal(String.valueOf(ellipsisValue * 7 + 20 + 32));
                            width = b.setScale(0, RoundingMode.UP).intValue();
                            item.put("slotValue", ellipsisValue);
                            break;
                        }
                        case BADGE: {
                            item.put("slotKeyMap", (Object)String.valueOf(slot.get("keyMap")));
                            width = 130;
                            break;
                        }
                        default: {
                            String actionText = slot.optString("actionText", "\u8be6\u60c5");
                            item.put("slotValue", (Object)actionText);
                            break;
                        }
                    }
                } else {
                    throw new WebException(500, "\u5217[" + key + "]\u65e0\u6cd5\u9002\u7528\u63d2\u69fd\uff0c\u56e0\u4e3a\u6ca1\u6709\u6307\u5b9a\u63d2\u69fd\u7c7b\u578b\u53c2\u6570");
                }
                if (column.has("width")) {
                    width = column.getInt("width");
                }
                if (width > 0) {
                    item.put("width", width);
                }
                if (column.has("fixed")) {
                    String fixedType = column.getString("fixed");
                    ColumnFixedTypeEnum columnFixedTypeEnum = ColumnFixedTypeEnum.toType(fixedType);
                    if (columnFixedTypeEnum == null) {
                        throw new WebException(500, "\u5217[" + key + "]\u65e0\u6cd5\u9002\u7528\u56fa\u5b9a\u5217\uff0c\u56e0\u4e3a\u8fd9\u4e2a\u56fa\u5b9a\u5217\u7c7b\u578b\u4e0d\u5b58\u5728\uff1a" + fixedType);
                    }
                    item.put("fixed", (Object)fixedType);
                }
                showColumnArray.put((Object)item);
            }
            if (!dataModeObject.isQueryForm() && !dataModeObject.isAddOrEditForm()) continue;
            if (column.has("formType")) {
                String formType = column.getString("formType");
                formTypeEnum = FormTypeEnum.toType(formType);
                if (formTypeEnum == null) {
                    throw new WebException(500, "\u5217[" + key + "]\u65e0\u6cd5\u751f\u6210\u8868\u5355\u9879\uff0c\u56e0\u4e3a\u8fd9\u4e2a\u8868\u5355\u7c7b\u578b\u4e0d\u5b58\u5728\uff1a" + formType);
                }
            } else {
                formTypeEnum = FormTypeEnum.INPUT;
            }
            if (dataModeObject.isAddOrEditForm()) {
                if (column.has("addOrEdit")) {
                    String addOrEditType = column.getString("addOrEdit");
                    addOrEditTypeEnum = AddOrEditTypeEnum.toType(addOrEditType);
                    if (addOrEditTypeEnum == null) {
                        throw new WebException(500, "\u5217[" + key + "]\u65e0\u6cd5\u751f\u6210\u8868\u5355\u9879\uff0c\u56e0\u4e3a\u8fd9\u4e2a\u65b0\u589e/\u4fee\u6539\u573a\u666f\u7c7b\u578b\u4e0d\u5b58\u5728\uff1a" + addOrEditType);
                    }
                } else {
                    addOrEditTypeEnum = AddOrEditTypeEnum.ALL;
                }
            } else {
                addOrEditTypeEnum = AddOrEditTypeEnum.NO;
            }
            JSONObject item = new JSONObject();
            if (formTypeEnum == FormTypeEnum.FILE || formTypeEnum == FormTypeEnum.IMAGE) {
                item.put("accept", (Object)column.getJSONArray("accept"));
                item.put("resUploadMode", (Object)column.getString("resUploadMode"));
                item.put("acceptCount", column.getInt("acceptCount"));
            }
            item.put("model", (Object)key.replace('.', '_'));
            item.put("type", (Object)formTypeEnum.getValue());
            item.put("name", (Object)column.getString("title"));
            item.put("group", column.has("group") ? column.getString("group") : null);
            item.put("groupIndex", column.has("groupIndex") ? Integer.valueOf(column.getInt("groupIndex")) : null);
            if (column.has("selectKeyName")) {
                String selectKeyName = column.getString("selectKeyName");
                String joinTableAlias = selectKeyName.substring(0, selectKeyName.indexOf(46));
                index = key.indexOf(46);
                index = index == -1 ? 0 : ++index;
                String realSelectKey = selectKeyName.substring(index);
                if (!selectKeyName.equals(key)) {
                    sql.append("\n\t").append(selectKeyName).append(" ").append(joinTableAlias).append("_").append(realSelectKey).append(",");
                    JSONObject selectColumnItem = new JSONObject();
                    selectColumnItem.put("queryType", (Object)QueryTypeEnum.EQUALS.getValue());
                    selectColumnItem.put("key", (Object)selectKeyName);
                    selectColumnArray.put(selectKeyName, (Object)selectColumnItem);
                    item.put("model", (Object)selectKeyName.replace('.', '_'));
                }
            }
            if (column.has("selectKey")) {
                Object selectKey = column.get("selectKey");
                if (selectKey instanceof JSONArray) {
                    item.put("keys", selectKey);
                } else {
                    item.put("keyName", selectKey);
                }
                if (column.has("lazyLoad")) {
                    item.put("lazyLoad", column.get("lazyLoad"));
                }
            }
            if (column.has("rule")) {
                JSONObject ruleObject = column.getJSONObject("rule");
                if (ruleObject.has("type")) {
                    String ruleType = ruleObject.getString("type");
                    RuleTypeEnum ruleTypeEnum = RuleTypeEnum.toType(ruleType);
                    if (ruleTypeEnum == null) {
                        throw new WebException(500, "\u5217[" + key + "]\u65e0\u6cd5\u751f\u6210\u8868\u5355\u9879\uff0c\u56e0\u4e3a\u8fd9\u4e2a\u8868\u5355\u6821\u9a8c\u7c7b\u578b\u4e0d\u5b58\u5728\uff1a" + ruleType);
                    }
                } else {
                    ruleObject.put("type", (Object)RuleTypeEnum.STRING.getValue());
                }
                item.put("rule", (Object)ruleObject);
            }
            if (column.has("placeholder")) {
                item.put("placeholder", (Object)column.getString("placeholder"));
            }
            item.put("addOrEdit", (Object)addOrEditTypeEnum.getValue());
            item.put("isOnlyAddOrEdit", !dataModeObject.isQueryForm());
            if (addOrEditTypeEnum == AddOrEditTypeEnum.SILENCE_ADD) {
                if (column.has("silencePurpose")) {
                    String silencePurpose = column.getString("silencePurpose");
                    SilencePurposeEnum silencePurposeEnum = SilencePurposeEnum.toType(silencePurpose);
                    if (silencePurposeEnum == null) {
                        throw new WebException(500, "\u5217[" + key + "]\u65e0\u6cd5\u751f\u6210\u8868\u5355\u9879\uff0c\u56e0\u4e3a\u8fd9\u4e2a\u9759\u9ed8\u65b0\u589e\u573a\u666f\u6307\u5b9a\u7684\u5b57\u6bb5\u7528\u9014\u4e0d\u5b58\u5728\uff1a" + silencePurpose);
                    }
                    if (silencePurposeEnum == SilencePurposeEnum.CUSTOMIZE) {
                        if (column.has("silenceSource")) {
                            item.put("silenceSource", (Object)column.getString("silenceSource"));
                        } else {
                            throw new WebException(500, "\u5217[" + key + "]\u65e0\u6cd5\u751f\u6210\u8868\u5355\u9879\uff0c\u56e0\u4e3a\u9759\u9ed8\u65b0\u589e\u573a\u666f\u7684\u81ea\u5b9a\u4e49\u5b57\u6bb5\u7528\u9014\u5fc5\u987b\u6307\u5b9a\u4e1a\u52a1\u903b\u8f91\u540d\u79f0(silenceSource)");
                        }
                    }
                    item.put("silencePurpose", (Object)column.getString("silencePurpose"));
                } else {
                    throw new WebException(500, "\u5217[" + key + "]\u65e0\u6cd5\u751f\u6210\u8868\u5355\u9879\uff0c\u56e0\u4e3a\u9759\u9ed8\u65b0\u589e\u573a\u666f\u5fc5\u987b\u6307\u5b9a\u5b57\u6bb5\u7528\u9014");
                }
            }
            formItemArray.put((Object)item);
        }
        String orderBy = realQueryParamsMap.getString("orderBy");
        String joinTableAlias = orderBy.substring(0, orderBy.indexOf(46));
        QueryParamsServer.putJoinCondition(joinTableAlias, tableAliasName, joinTableNameObject, canJoinTableNameObject, false);
        if (realQueryParamsMap.has("condition")) {
            JSONObject condition = realQueryParamsMap.getJSONObject("condition");
            conditionStr = condition.getString("value");
            if (condition.has("join")) {
                JSONArray joinArray = condition.getJSONArray("join");
                for (Object item : joinArray) {
                    String joinItem = item.toString();
                    QueryParamsServer.putJoinCondition(joinItem, tableAliasName, joinTableNameObject, canJoinTableNameObject, true);
                }
            }
        } else {
            conditionStr = "1=1";
        }
        sql.deleteCharAt(sql.length() - 1);
        sql.append("\n").append("FROM ").append(tableName);
        countSql.append("\n").append("FROM ").append(tableName);
        JSONObject result = new JSONObject();
        result.put("tableName", (Object)tableName);
        result.put("tableAliasName", (Object)tableAliasName);
        result.put("countSql", (Object)countSql.toString());
        result.put("querySql", (Object)sql.toString());
        result.put("joinTableNameObject", (Object)joinTableNameObject);
        result.put("canJoinTableNameObject", (Object)canJoinTableNameObject);
        result.put("selectColumn", (Object)selectColumnArray);
        result.put("orderBy", (Object)orderBy);
        result.put("condition", (Object)conditionStr);
        result.put("columnJson", (Object)showColumnArray);
        result.put("formJson", (Object)formItemArray);
        result.put("buttonState", (Object)buttonState);
        return result;
    }

    public static JSONObject getSimpleFormInfo(JSONObject realQueryParamsMap) {
        String groupName = realQueryParamsMap.getString("group");
        String describe = realQueryParamsMap.getString("describe");
        JSONArray queryColumnArray = realQueryParamsMap.getJSONArray("column");
        JSONArray formItemArray = new JSONArray(queryColumnArray.length());
        for (Object columnItem : queryColumnArray) {
            FormTypeEnum formTypeEnum;
            JSONObject column = (JSONObject)columnItem;
            String key = column.getString("key");
            if (column.has("formType")) {
                String formType = column.getString("formType");
                formTypeEnum = FormTypeEnum.toType(formType);
                if (formTypeEnum == null) {
                    throw new WebException(500, "\u5217[" + key + "]\u65e0\u6cd5\u751f\u6210\u8868\u5355\u9879\uff0c\u56e0\u4e3a\u8fd9\u4e2a\u8868\u5355\u7c7b\u578b\u4e0d\u5b58\u5728\uff1a" + formType);
                }
            } else {
                formTypeEnum = FormTypeEnum.INPUT;
            }
            JSONObject item = new JSONObject();
            item.put("model", (Object)key.replace('.', '_'));
            item.put("type", (Object)formTypeEnum.getValue());
            item.put("name", (Object)column.getString("title"));
            if (column.has("selectKey")) {
                String selectKey = String.valueOf(column.get("selectKey"));
                if (selectKey.startsWith("[") && selectKey.endsWith("]")) {
                    item.put("keys", (Object)new JSONArray(selectKey));
                } else {
                    item.put("keyName", (Object)selectKey);
                }
            }
            if (column.has("rule")) {
                JSONObject ruleObject = column.getJSONObject("rule");
                if (ruleObject.has("type")) {
                    String ruleType = ruleObject.getString("type");
                    RuleTypeEnum ruleTypeEnum = RuleTypeEnum.toType(ruleType);
                    if (ruleTypeEnum == null) {
                        throw new WebException(500, "\u5217[" + key + "]\u65e0\u6cd5\u751f\u6210\u8868\u5355\u9879\uff0c\u56e0\u4e3a\u8fd9\u4e2a\u8868\u5355\u6821\u9a8c\u7c7b\u578b\u4e0d\u5b58\u5728\uff1a" + ruleType);
                    }
                } else {
                    ruleObject.put("type", (Object)RuleTypeEnum.STRING.getValue());
                }
                item.put("rule", (Object)ruleObject);
            }
            if (column.has("placeholder")) {
                item.put("placeholder", (Object)column.getString("placeholder"));
            }
            item.put("addOrEdit", (Object)AddOrEditTypeEnum.ALL.getValue());
            item.put("isOnlyAddOrEdit", true);
            formItemArray.put((Object)item);
        }
        JSONObject columnResult = new JSONObject();
        columnResult.put("formJson", (Object)formItemArray);
        columnResult.put("groupName", (Object)groupName);
        columnResult.put("describe", (Object)describe);
        return columnResult;
    }

    public static void putJoinCondition(String joinTableAlias, String tableAliasName, JSONObject joinTableNameObject, JSONArray canJoinTableNameObject, Boolean useJoinByCount) {
        if (joinTableAlias.equals(tableAliasName)) {
            return;
        }
        if (joinTableNameObject.has(joinTableAlias)) {
            boolean isContains;
            JSONObject params = null;
            boolean bl = isContains = QueryParamsServer.getCanJoinTableItem(canJoinTableNameObject, joinTableAlias) != null;
            if (!isContains) {
                String joinCondition = joinTableNameObject.getString(joinTableAlias).toLowerCase();
                String shouldJoinTableAlias = QueryParamsServer.getShouldJoinTableAlias(joinTableAlias, tableAliasName, joinCondition);
                if (shouldJoinTableAlias != null) {
                    QueryParamsServer.putJoinCondition(shouldJoinTableAlias, tableAliasName, joinTableNameObject, canJoinTableNameObject, useJoinByCount);
                }
                params = new JSONObject();
                params.put("alias", (Object)joinTableAlias);
                params.put("useJoinByCount", (Object)useJoinByCount);
                params.put("value", (Object)("LEFT JOIN " + joinCondition));
                canJoinTableNameObject.put((Object)params);
            } else {
                String joinCondition;
                String shouldJoinTableAlias;
                params = QueryParamsServer.getCanJoinTableItem(canJoinTableNameObject, joinTableAlias);
                assert (params != null);
                params.put("useJoinByCount", (Object)useJoinByCount);
                if (useJoinByCount.booleanValue() && (shouldJoinTableAlias = QueryParamsServer.getShouldJoinTableAlias(joinTableAlias, tableAliasName, joinCondition = params.getString("value").toLowerCase())) != null) {
                    params = QueryParamsServer.getCanJoinTableItem(canJoinTableNameObject, shouldJoinTableAlias);
                    assert (params != null);
                    params.put("useJoinByCount", true);
                    QueryParamsServer.putJoinCondition(shouldJoinTableAlias, tableAliasName, joinTableNameObject, canJoinTableNameObject, true);
                }
            }
        } else {
            throw new WebException(500, "\u5728\u7ec4\u7ec7JOIN\u8868\u8fbe\u5f0f\u65f6\uff0c\u6ca1\u6709\u627e\u5230\u5173\u4e8e\u8868\u522b\u540d[" + joinTableAlias + "]\u7684JOIN\u8868\u8fbe\u5f0f\u914d\u7f6e\u4fe1\u606f");
        }
    }

    public static JSONObject getCanJoinTableItem(JSONArray canJoinTableNameObject, String alias) {
        for (Object itemObject : canJoinTableNameObject) {
            JSONObject item = (JSONObject)itemObject;
            if (!item.getString("alias").equals(alias)) continue;
            return item;
        }
        return null;
    }

    private static String getShouldJoinTableAlias(String joinTableAlias, String tableAliasName, String joinCondition) {
        String onCondition = joinCondition.substring(joinCondition.indexOf("on") + 3);
        String canJoinTableAliasA = onCondition.substring(0, onCondition.indexOf("."));
        String canJoinTableAliasB = onCondition.substring(onCondition.lastIndexOf("=") + 1, onCondition.lastIndexOf(".")).trim();
        if (!canJoinTableAliasA.equals(tableAliasName) && !canJoinTableAliasB.equals(tableAliasName)) {
            String shouldJoinTableAlias = canJoinTableAliasA.equals(joinTableAlias) ? canJoinTableAliasB : canJoinTableAliasA;
            return shouldJoinTableAlias;
        }
        return null;
    }

    public static JSONObject getQuerySQL(String queryParamsName, JSONObject params) throws Exception {
        JSONObject queryParamsMap = (JSONObject)ResourceHelper.getString(ResourceType.QUERY_PARAMS, queryParamsName, null);
        assert (queryParamsMap != null);
        return QueryParamsServer.getQuerySQL(queryParamsMap, params);
    }

    public static JSONObject getQuerySQL(JSONObject queryParamsMap, JSONObject params) throws Exception {
        String tableAliasName = queryParamsMap.getString("tableAliasName");
        StringBuilder querySql = new StringBuilder(queryParamsMap.getString("querySql"));
        StringBuilder countSql = new StringBuilder(queryParamsMap.getString("countSql"));
        JSONObject joinTableNameObject = queryParamsMap.getJSONObject("joinTableNameObject");
        JSONArray canJoinTableNameObject = queryParamsMap.getJSONArray("canJoinTableNameObject");
        String orderBy = queryParamsMap.getString("orderBy");
        String conditionStr = queryParamsMap.getString("condition");
        String whereCondition = QueryParamsServer.getValue(queryParamsMap.getJSONObject("selectColumn"), params, tableAliasName, joinTableNameObject, canJoinTableNameObject, conditionStr);
        for (Object item : canJoinTableNameObject) {
            JSONObject joinObject = (JSONObject)item;
            String condition = joinObject.getString("value");
            querySql.append("\n\t").append(condition);
            if (!joinObject.getBoolean("useJoinByCount")) continue;
            countSql.append("\n\t").append(condition);
        }
        querySql.append("\n").append("WHERE ").append(whereCondition);
        countSql.append("\n").append("WHERE ").append(whereCondition);
        querySql.append("\nORDER BY ").append(orderBy);
        JSONObject result = new JSONObject();
        result.put("querySql", (Object)querySql.toString());
        result.put("countSql", (Object)countSql.toString());
        return result;
    }

    public static JSONObject getSignleStyleQuerySQL(String queryParamsName, JSONObject params) throws Exception {
        JSONObject queryParams = QueryParamsServer.getQuerySQL(queryParamsName, params);
        return QueryParamsServer.getSignleStyleQuerySQL(queryParams);
    }

    public static JSONObject getSignleStyleQuerySQL(JSONObject queryParams) {
        String querySql = queryParams.getString("querySql");
        String countSql = queryParams.getString("countSql");
        JSONObject result = new JSONObject();
        result.put("items", (Object)querySql.substring(querySql.indexOf("SELECT") + 6, querySql.indexOf("FROM")));
        result.put("tableName", (Object)querySql.substring(querySql.indexOf("FROM") + 4, querySql.indexOf("WHERE")));
        result.put("condition", (Object)querySql.substring(querySql.indexOf("WHERE") + 5));
        result.put("countItems", (Object)countSql.substring(countSql.indexOf("SELECT") + 6, countSql.indexOf("FROM")));
        result.put("countTableName", (Object)countSql.substring(countSql.indexOf("FROM") + 4, countSql.indexOf("WHERE")));
        result.put("countCondition", (Object)countSql.substring(countSql.indexOf("WHERE") + 5));
        result.put("querySql", (Object)querySql);
        result.put("countSql", (Object)countSql);
        return result;
    }

    public static String getValue(JSONObject queryMap, JSONObject params, String tableAliasName, JSONObject joinTableNameObject, JSONArray canJoinTableNameObject, String conditionStr) {
        StringBuilder condition = new StringBuilder(conditionStr);
        Iterator iterator = params.keys();
        while (iterator.hasNext()) {
            String key = (String)iterator.next();
            String value = String.valueOf(params.get(key));
            if (value.length() == 0 || value.equals("\u5168\u90e8")) continue;
            if (key.indexOf(46) == -1) {
                key = key.replaceFirst("_", ".");
            }
            if (queryMap.has(key)) {
                JSONObject queryParams = queryMap.getJSONObject(key);
                String queryTypeStr = queryParams.getString("queryType");
                if (!QueryTypeEnum.is(queryTypeStr)) {
                    throw new WebException(500, "\u8868\u5355\u5b57\u6bb5[" + key + "]\u65e0\u6cd5\u751f\u6210\u67e5\u8be2\u6761\u4ef6\uff0c\u56e0\u4e3a\u914d\u7f6e\u7684\u67e5\u8be2\u7c7b\u578b\u4e0d\u5b58\u5728\uff1a" + queryTypeStr);
                }
                QueryTypeEnum queryType = QueryTypeEnum.toType(queryTypeStr);
                String realKey = queryParams.getString("key");
                switch (queryType) {
                    case EQUALS: 
                    case NO_EQUALS: 
                    case LESS_THAN: 
                    case LESS_THAN_EQUALS: 
                    case GREATER_THAN: 
                    case GREATER_THAN_EQUALS: {
                        String mark = queryType.getValue();
                        if (value.equalsIgnoreCase("NULL")) {
                            condition.append("\n\tAND ").append(realKey).append(" IS NULL");
                            break;
                        }
                        condition.append("\n\tAND ").append(realKey).append(" ").append(mark).append(" '").append(value).append("'");
                        break;
                    }
                    case INNER_LIKE: {
                        condition.append("\n\tAND ").append(realKey).append(" LIKE '%").append(value).append("%'");
                        break;
                    }
                    case LEFT_LIKE: {
                        condition.append("\n\tAND ").append(realKey).append(" LIKE '%").append(value).append("'");
                        break;
                    }
                    case RIGHT_LIKE: {
                        condition.append("\n\tAND ").append(realKey).append(" LIKE '").append(value).append("%'");
                        break;
                    }
                    case IN: {
                        condition.append("\n\tAND ").append(realKey).append(" IN (").append(value).append(")");
                        break;
                    }
                    case NOT_IN: {
                        condition.append("\n\tAND ").append(realKey).append(" NOT IN (").append(value).append(")");
                        break;
                    }
                    case BETWEEN: {
                        JSONArray array = new JSONArray(value);
                        condition.append("\n\tAND ").append(realKey).append(" BETWEEN '").append(array.get(0)).append("' AND '").append(array.get(1)).append("'");
                    }
                }
                String joinTableAlias = realKey.substring(0, realKey.indexOf(46));
                QueryParamsServer.putJoinCondition(joinTableAlias, tableAliasName, joinTableNameObject, canJoinTableNameObject, true);
                continue;
            }
            throw new WebException(500, "\u8868\u5355\u5b57\u6bb5[" + key + "]\u65e0\u6cd5\u751f\u6210\u67e5\u8be2\u6761\u4ef6\uff0c\u56e0\u4e3a\u6ca1\u6709\u914d\u7f6e\u8fd9\u4e2a\u5b57\u6bb5\u7684\u76f8\u5173\u4fe1\u606f");
        }
        return condition.toString();
    }
}

