/*
 * Decompiled with CFR 0.152.
 */
package com.aote.manager;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.json.JSONArray;
import org.json.JSONObject;

public class VueServer {
    private final Pattern pattern = Pattern.compile("'([^']*)'");

    public JSONArray getData() {
        JSONArray result = new JSONArray();
        InputStream input = VueServer.class.getClassLoader().getResourceAsStream("main.js");
        try {
            JSONObject item = null;
            BufferedReader reader = new BufferedReader(new InputStreamReader(input, StandardCharsets.UTF_8));
            String line = reader.readLine();
            while (line != null) {
                if (line.startsWith("//")) {
                    JSONObject json = this.getJSON(line);
                    if (json != null) {
                        item = json;
                    }
                } else if (line.startsWith("Vue.component('")) {
                    if (item == null) {
                        item = new JSONObject();
                        item.put("summery", (Object)"");
                    }
                    this.procElement(line, item);
                    result.put((Object)item);
                    item = null;
                }
                line = reader.readLine();
            }
            return result;
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    private JSONObject getJSON(String text) {
        JSONObject result = new JSONObject();
        result.put("summery", (Object)text.substring(2));
        return result;
    }

    private void procElement(String text, JSONObject json) {
        Matcher matcher = this.pattern.matcher(text);
        if (matcher.find()) {
            String name = matcher.group(1);
            json.put("name", (Object)name);
        } else {
            json.put("name", (Object)"");
        }
        if (matcher.find()) {
            String path = matcher.group(1);
            json.put("text", (Object)("\u8def\u5f84: " + path));
        } else {
            json.put("text", (Object)"");
        }
    }
}

