/*
 * Decompiled with CFR 0.152.
 */
package com.aote.logic;

import com.aote.config.SystemConfig;
import com.aote.entity.EntityServer;
import com.aote.exception.ExceptionLogManage;
import com.aote.logic.LogicMapper;
import com.aote.logic.PluginMapper;
import com.aote.path.PathMapper;
import com.aote.path.PathServer;
import com.aote.redis.RedisUtil;
import com.aote.rs.mapper.WebException;
import com.aote.sql.SqlMapper;
import com.aote.sql.SqlServer;
import com.aote.transaction.SessionPool;
import com.aote.util.ExceptionHelper;
import com.aote.util.ExpressionHelper;
import com.aote.util.ResourceHelper;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.json.JSONArray;
import org.json.JSONObject;
import org.json.JSONTokener;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
@Transactional
public class LogicServer {
    static final Logger log = Logger.getLogger(LogicServer.class);
    @Autowired
    private EntityServer entityServer;
    @Autowired
    private SqlServer sqlServer;
    @Autowired
    private PathServer pathServer;
    @Autowired
    public SessionPool sessionPool;
    @Autowired
    public SessionFactory sessionFactory;
    @Autowired
    private ExceptionLogManage exceptionLogManage;
    private final RedisUtil redisUtil = RedisUtil.getInstance();
    private JSONObject context = null;

    public Object run(String name, String str) throws Exception {
        JSONObject param = null;
        if ((str = str.trim()).startsWith("<") && str.endsWith(">")) {
            param = new JSONObject();
            param.put("xml", (Object)str);
        } else {
            Object json = new JSONTokener(str).nextValue();
            if (json instanceof JSONObject) {
                Object dataParam;
                param = new JSONObject(str);
                if (!param.isNull("context")) {
                    this.context = param.getJSONObject("context");
                }
                if (!param.isNull("data") && (dataParam = param.get("data")) instanceof JSONObject) {
                    param = (JSONObject)dataParam;
                    param.put("standardData", (Object)new JSONObject(str).toString());
                }
            } else if (json instanceof JSONArray) {
                param = new JSONObject();
                param.put("arr", (Object)new JSONArray(str));
            }
        }
        return this.run(name, param, this.context);
    }

    public Object run(String name, JSONObject param) throws Exception {
        return this.run(name, param, this.context);
    }

    /*
     * Exception decompiling
     */
    public Object run(String name, JSONObject param, JSONObject context) throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public String runMain(String logicName, String values) throws Exception {
        try {
            Object result = this.run(logicName, values);
            if (result == null) {
                return "";
            }
            if (result instanceof Map) {
                JSONObject json = new JSONObject((Map)result);
                return json.toString();
            }
            if (result instanceof JSONObject) {
                JSONObject json = (JSONObject)result;
                return json.toString();
            }
            return result.toString();
        }
        catch (Exception ex) {
            String stack = ExceptionLogManage.getErrorInfo(ExceptionHelper.stackToString(ex), 1);
            log.error((Object)stack);
            String path = LogicMapper.getLogic(logicName);
            if (path == null) {
                path = logicName;
            }
            this.exceptionLogManage.writeError(ex, path, "/rs/logic/" + logicName, values);
            WebException wex = this.getWebException(ex);
            if (wex != null) {
                throw wex;
            }
            throw ex;
        }
    }

    @Async(value="AsyncLogicGet")
    public void runAsync(String logicName, String values) throws Exception {
        this.runMain(logicName, values);
    }

    public Object runLogic(String source, JSONObject param, JSONObject context) {
        source = source.replace("\r\n", "\n");
        return ExpressionHelper.run(source, this.getContext(param, context));
    }

    private Map<String, Object> getContext(JSONObject param, JSONObject context) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("data", param);
        if (context != null) {
            params.put("context", context);
        }
        params.put("log", log);
        params.put("entity", this.entityServer);
        params.put("sql", this.sqlServer);
        params.put("path", this.pathServer);
        params.put("session", this.sessionPool.getSession());
        params.put("redis", this.redisUtil);
        params.put("logic", this);
        Map<String, Object> plugins = PluginMapper.getPlugins();
        params.putAll(plugins);
        return params;
    }

    public Object noTranscRun(String name, JSONObject param) throws Exception {
        String path = LogicMapper.getLogic(name);
        String source = ResourceHelper.getString("/logics/" + path);
        source = source.replace("\r\n", "\n");
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("data", param);
        params.put("log", log);
        params.put("entity", this.entityServer);
        SqlServer sqlServer = new SqlServer();
        try (Session session = null;){
            session = this.sessionFactory.openSession();
            sqlServer.setAssignedSession(session);
            params.put("sql", sqlServer);
            params.put("session", session);
            params.put("logic", this);
            Map<String, Object> plugins = PluginMapper.getPlugins();
            for (String key : plugins.keySet()) {
                params.put(key, plugins.get(key));
            }
            Object object = ExpressionHelper.run(source, params);
            return object;
        }
    }

    public void debug(String logic, Object msg) {
        String level = LogicMapper.getAttr(logic, "log");
        if (level != null) {
            log.debug((Object)(logic + ":" + msg));
        }
    }

    public void redisCacheLogic() {
        if (SystemConfig.Redis.hasHostName() && SystemConfig.Redis.hasRegisterUrl()) {
            String url = SystemConfig.Redis.getRegisterUrl();
            Map<String, Map<String, String>> map = LogicMapper.getMap();
            if (map != null) {
                for (String key : map.keySet()) {
                    this.redisUtil.set(key, url);
                    log.info((Object)("logic\u52a0\u5165redis\u7f13\u5b58\uff0ckey=" + key + ", value=" + url));
                }
            }
            if ((map = SqlMapper.getMap()) != null) {
                for (String key : map.keySet()) {
                    this.redisUtil.set(key, url);
                    log.info((Object)("sql\u52a0\u5165redis\u7f13\u5b58\uff0ckey=" + key + ", value=" + url));
                }
            }
            if ((map = PathMapper.getMap()) != null) {
                for (String key : map.keySet()) {
                    this.redisUtil.set(key, url);
                    log.info((Object)("path\u52a0\u5165redis\u7f13\u5b58\uff0ckey=" + key + ", value=" + url));
                }
            }
            Map entities = this.sessionFactory.getAllClassMetadata();
            for (String key : entities.keySet()) {
                this.redisUtil.set(key, url);
                log.info((Object)("entity\u52a0\u5165redis\u7f13\u5b58\uff0ckey=" + key + ", value=" + url));
            }
        }
    }

    private WebException getWebException(Exception ex) {
        for (Throwable cause = ex; cause != null; cause = cause.getCause()) {
            if (!(cause instanceof WebException)) continue;
            return (WebException)cause;
        }
        return null;
    }

    private static /* synthetic */ String lambda$run$0(String s) {
        return s;
    }
}

