package com.aote.sql;

import org.hibernate.transform.AliasedTupleSubsetResultTransformer;
import org.json.JSONObject;

import java.io.Reader;
import java.sql.Clob;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public class AliasTransformer extends AliasedTupleSubsetResultTransformer {

	public static final AliasTransformer INSTANCE = new AliasTransformer();

	/**
	 * Disallow instantiation of AliasToEntityMapResultTransformer.
	 */
	private AliasTransformer() {
	}

	@Override
	public Object transformTuple(Object[] tuple, String[] aliases) {
		SimpleDateFormat SIMPLE_DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
		Map<String, Object> result = new HashMap<>(tuple.length);
		for ( int i = 0; i < aliases.length; i++ ) {
			String alias = aliases[i];
			if (alias != null) {
				Object value = tuple[i];
				if(value == null){
					value = JSONObject.NULL;
				} else if(value instanceof Date){
					value = SIMPLE_DATE_FORMAT.format(value);
				} else if(value instanceof Clob){
					value = getClobString((Clob) value);
				}
				result.put(alias.toLowerCase(), value);
			}
		}
		return result;
	}

	@Override
	public boolean isTransformedValueATupleElement(String[] aliases, int tupleLength) {
		return false;
	}

	/**
	 * Serialization hook for ensuring singleton uniqueing.
	 *
	 * @return The singleton instance : {@link #INSTANCE}
	 */
	private Object readResolve() {
		return INSTANCE;
	}

	public static String getClobString(Clob c) {
		try {
			Reader reader=c.getCharacterStream();
			if (reader == null) {
				return null;
			}
			StringBuilder sb = new StringBuilder();
			char[] charArr = new char[4096];
			for (int i = reader.read(charArr); i > 0; i = reader.read(charArr)) {
				sb.append(charArr, 0, i);
			}
			return sb.toString();
		} catch (Exception e) {
			return "";
		}
	}
}
