package com.aote.rs;

import com.aote.path.PathMapper;
import com.aote.path.PathServer;
import com.aote.util.ExceptionHelper;
import com.aote.util.other.AESUtil;
import org.apache.log4j.Logger;
import org.json.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.QueryParam;

/**
 * 提供path查询服务
 */
@Path("path")
@Component
@Transactional
public class PathService {
	static final Logger log = Logger.getLogger(PathService.class);

	@Autowired
	private PathServer pathServer;

	/**
	 * 获取path查询的总数
	 * @param name path查询
	 * @param str 查询所需参数
	 * @return 总数
	 */
	@POST
	@Path("{name}/n")
	public String txgetTotalCnt(@PathParam("name") String name, String str)
			throws Exception {
		try {
			return pathEncrypt(name, str, false);
		} catch (Exception ex) {
			log.error(ExceptionHelper.stackToString(ex));
			throw ex;
		}
	}

	/**
	 * 执行path,对path中的参数进行替换 pageNo - 页号，默认为1 pageSize - 每页个数，默认为1000
	 */
	@POST
	@Path("{name}")
	public String txPath(@PathParam("name") String name,
						 @QueryParam("pageNo") int pageNo,
						 @QueryParam("pageSize") int pageSize, String str) throws Exception {
		try {
			String level = PathMapper.getAttr(name, "log");
			if (level != null) {
				log.info(name + ":" + str);
			}
			String ret = pathEncrypt(name, str, true, pageNo, pageSize);
			if (level != null) {
				log.info(name + ":" + ret);
			}
			return ret;
		} catch (Exception ex) {
			log.error(ExceptionHelper.stackToString(ex));
			throw ex;
		}
	}

	/**
	 * 封装path加解密
	 * @param pathName path名
	 * @param param	参数
	 * @param isQuery 区分调用
	 * @param values 接收分页的两个参数
	 * @return
	 * @throws Exception
	 */
	public String pathEncrypt(String pathName, String param, boolean isQuery, int ... values)throws Exception{
		JSONObject paramJson = new JSONObject(param);

		return AESUtil.encryptData(paramJson,
				(data) -> isQuery ? pathServer.query(pathName, values[0], values[1], data).toString() :
						pathServer.queryTotal(pathName, data).toString()
		);
	}
}
