package com.aote.util.dialect;

/**
 * Oracle数据源方言兼容性组件
 */
public class OracleDialect extends DataSourceDialect {

    @Override
    public String getSql(String sql) {
        sql = sql.replaceAll("(isnull|ISNULL)","nvl")
        //        .replace("+","||")
                .replaceAll("(substring|SUBSTRING)","substr")
                .replaceAll("(getdate|GETDATE)\\(\\)","sysdate")
                // 处理 convert(numeric|decimal)
                .replaceAll("(convert|CONVERT)\\s*\\(\\s*(numeric|NUMERIC)\\s*\\(\\s*\\d+\\s*,\\s*\\d+\\s*\\)\\s*,{1}","to_number(")
                .replaceAll("(convert|CONVERT)\\s*\\(\\s*(decimal|DECIMAL)\\s*\\(\\s*\\d+\\s*,\\s*\\d+\\s*\\)\\s*,{1}","to_number(")
                // 处理convert(varchar|varchar(11),h.f_hand_date|'2020-01-22 00:00:01',21|23)
                .replaceAll("(convert|CONVERT)\\s*\\(\\s*(varchar|VARCHAR)\\s*,{1}\\s*([']?\\d{4}-\\d{2}-\\d{2}\\s{1}\\d{2}:\\d{2}:\\d{2}[']?)\\s*,\\s*(21|23)\\s*\\)"," to_char($3,'yyyy-mm-dd') ")
                .replaceAll("(convert|CONVERT)\\s*\\(\\s*(varchar|VARCHAR)\\s*\\(\\s*\\d+\\s*\\)?\\s*,{1}\\s*([']?\\d{4}-\\d{2}-\\d{2}\\s{1}\\d{2}:\\d{2}:\\d{2}[']?)\\s*,\\s*(21|23)\\s*\\)"," to_char($3,'yyyy-mm-dd') ")
                .replaceAll("(convert|CONVERT)\\s*\\(\\s*(varchar|VARCHAR)\\s*,{1}\\s*([a-zA-Z0-9_\\.]+)\\s*,\\s*(21|23)\\s*\\)"," to_char($3,'yyyy-mm-dd') ")
                .replaceAll("(convert|CONVERT)\\s*\\(\\s*(varchar|VARCHAR)\\s*\\(\\s*\\d+\\s*\\)?\\s*,{1}\\s*([a-zA-Z0-9_\\.]+)\\s*,\\s*(21|23)\\s*\\)"," to_char($3,'yyyy-mm-dd') ")
                // 处理convert(varchar|varchar(11),h.f_hand_date|'2020-01-22 00:00:01',103|!23|!21)
                .replaceAll("(convert|CONVERT)\\s*\\(\\s*(varchar|VARCHAR)\\s*,{1}\\s*([']?\\d{4}-\\d{2}-\\d{2}\\s{1}\\d{2}:\\d{2}:\\d{2}[']?)\\s*,\\s*\\d+\\s*\\)"," to_char($3,'yyyy-mm-dd hh24:mi:ss') ")
                .replaceAll("(convert|CONVERT)\\s*\\(\\s*(varchar|VARCHAR)\\s*\\(\\s*\\d+\\s*\\)?\\s*,{1}\\s*([']?\\d{4}-\\d{2}-\\d{2}\\s{1}\\d{2}:\\d{2}:\\d{2}[']?)\\s*,\\s*\\d+\\s*\\)"," to_char($3,'yyyy-mm-dd hh24:mi:ss') ")
                .replaceAll("(convert|CONVERT)\\s*\\(\\s*(varchar|VARCHAR)\\s*,{1}\\s*([a-zA-Z0-9_\\.]+)\\s*,\\s*\\d+\\s*\\)"," to_char($3,'yyyy-mm-dd hh24:mi:ss') ")
                .replaceAll("(convert|CONVERT)\\s*\\(\\s*(varchar|VARCHAR)\\s*\\(\\s*\\d+\\s*\\)?\\s*,{1}\\s*([a-zA-Z0-9_\\.]+)\\s*,\\s*\\d+\\s*\\)"," to_char($3,'yyyy-mm-dd hh24:mi:ss') ")
                // 处理 convert(varchar|varchar(11),convert(xx),23)
                .replaceAll("(convert|CONVERT)\\s*\\(\\s*(varchar|VARCHAR)\\s*\\(\\s*\\d+\\s*\\)?\\s*,\\s*([\\(\\),a-zA-Z0-9_\\.-]+)\\s*,\\s*(21|23)\\)",
                        "to_char($3,'yyyy-mm-dd')")
                .replaceAll("(convert|CONVERT)\\s*\\(\\s*(varchar|VARCHAR)\\s*\\(\\s*\\d+\\s*\\)?\\s*,\\s*([\\(\\),a-zA-Z0-9_\\.-]+)\\s*,\\s*\\d+\\)",
                        "to_char($3,'yyyy-mm-dd hh24:mi:ss')")
                .replaceAll("(convert|CONVERT)\\s*\\(\\s*(varchar|VARCHAR)\\s*,\\s*([\\(\\),a-zA-Z0-9_\\.-]+)\\s*,\\s*(21|23)\\)",
                        "to_char($3,'yyyy-mm-dd')")
                .replaceAll("(convert|CONVERT)\\s*\\(\\s*(varchar|VARCHAR)\\s*,\\s*([\\(\\),a-zA-Z0-9_\\.-]+)\\s*,\\s*\\d+\\)",
                        "to_char($3,'yyyy-mm-dd hh24:mi:ss')")
                // 对sysdate特殊处理convert(varchar|varchar(xx),sysdate)
                .replaceAll("(convert|CONVERT)\\s*\\(\\s*(varchar|VARCHAR)\\s*,{1}\\s*(sysdate|SYSDATE)\\s*\\)","to_char($3,'yyyy-mm-dd hh24:mi:ss')")   //处理convert(varchar,xxx)
                .replaceAll("(convert|CONVERT)\\s*\\(\\s*(varchar|VARCHAR)\\s*\\(\\s*\\d+\\s*\\)?\\s*,{1}\\s*(sysdate|SYSDATE)\\s*\\)","to_char($3,'yyyy-mm-dd hh24:mi:ss')")
                // 处理 convert(varchar|varchar(xx),'2021-02-12 00:00:00')
                .replaceAll("(convert|CONVERT)\\s*\\(\\s*(varchar|VARCHAR)\\s*,{1}\\s*([']?\\d{4}-\\d{2}-\\d{2}\\s{1}\\d{2}:\\d{2}:\\d{2}[']?)\\s*\\)","to_char($3,'yyyy-mm-dd hh24:mi:ss')")   //处理convert(varchar,xxx)
                .replaceAll("(convert|CONVERT)\\s*\\(\\s*(varchar|VARCHAR)\\s*\\(\\s*\\d+\\s*\\)?\\s*,{1}\\s*([']?\\d{4}-\\d{2}-\\d{2}\\s{1}\\d{2}:\\d{2}:\\d{2}[']?)\\s*\\)","to_char($3,'yyyy-mm-dd hh24:mi:ss')")
                //剔除 sysdate 不需要进行 to_char(to_date($3,'yyyy-mm-dd hh24:mi:ss')
                .replaceAll("(convert|CONVERT)\\s*\\(\\s*(datetime|DATE|date|DATETIME)\\s*,(sysdate|SYSDATE),(21|23)\\)","to_char(sysdate,'yyyy-mm-dd')")
                .replaceAll("(convert|CONVERT)\\s*\\(\\s*(datetime|DATE|date|DATETIME)\\s*,(sysdate|SYSDATE),2[^13]\\)"," sysdate ")
                .replaceAll("(convert|CONVERT)\\s*\\(\\s*(datetime|DATE|date|DATETIME)\\s*,(sysdate|SYSDATE),\\d*\\)"," sysdate ")
                // 对convert(DATE,h.f_hand_date|'2020-09-10 11:33:14.947',21/23) convert(DATE,h.f_hand_date|'2020-09-10 11:33:14.947',^21/23) 处理
                .replaceAll("(convert|CONVERT)\\s*\\(\\s*(datetime|DATE|date|DATETIME)\\s*,([a-zA-Z0-9_\\.]+),(21|23)\\)","to_char(to_date($3,'yyyy-mm-dd hh24:mi:ss'),'yyyy-mm-dd')")  //convert(DATE,h.f_hand_date,21/23)
                .replaceAll("(convert|CONVERT)\\s*\\(\\s*(datetime|DATE|date|DATETIME)\\s*,([']?\\d{4}-\\d{2}-\\d{2}\\s{1}\\d{2}:\\d{2}:\\d{2}[']?),(21|23)\\)","to_char($3,'yyyy-mm-dd')")  //convert(DATE,h.f_hand_date,^21/23)
                .replaceAll("(convert|CONVERT)\\s*\\(\\s*(datetime|DATE|date|DATETIME)\\s*,([a-zA-Z0-9_\\.]+),2[^13]\\)","to_date($3,'yyyy-mm-dd hh24:mi:ss')")
                .replaceAll("(convert|CONVERT)\\s*\\(\\s*(datetime|DATE|date|DATETIME)\\s*,([']?\\d{4}-\\d{2}-\\d{2}\\s{1}\\d{2}:\\d{2}:\\d{2}[']?),2[^13]\\)"," $3 ")
                // 对convert(DATE,h.f_hand_date|'2020-09-10 11:33:14.947',xxx) 处理
                .replaceAll("(convert|CONVERT)\\s*\\(\\s*(datetime|DATE|date|DATETIME)\\s*,([a-zA-Z0-9_\\.]+),\\d*\\)","to_date($3,'yyyy-mm-dd hh24:mi:ss')")
                .replaceAll("(convert|CONVERT)\\s*\\(\\s*(datetime|DATE|date|DATETIME)\\s*,([']?\\d{4}-\\d{2}-\\d{2}\\s{1}\\d{2}:\\d{2}:\\d{2}[']?),\\d*\\)"," $3 ")

                .replaceAll("(convert|CONVERT)\\s*\\(\\s*(varchar|VARCHAR)\\s*,{1}","to_char(")   //处理convert(varchar,xxx)
                .replaceAll("(convert|CONVERT)\\s*\\(\\s*(varchar|VARCHAR)\\s*\\(\\s*\\d+\\s*\\)?\\s*,{1}","to_char(")  //处理convert(varchar(22),xxx)
                .replaceAll("(convert|CONVERT)\\s*\\(\\s*(datetime|DATE|date|DATETIME)\\s*,{1}","to_date(")  //convert(DATE,h.f_hand_date)
                .replaceAll("(cast|CAST)\\s*\\(\\s*([\\(\\)*%/'a-zA-Z0-9_\\.]+)\\s+as\\s+(varchar|VARCHAR)\\s*\\)","to_char($2)")   //cast(12_2a33 as varchar)
                .replaceAll("(cast|CAST)\\s*\\(\\s*([\\(\\)*%/'a-zA-Z0-9_\\.]+)\\s+as\\s+(varchar|VARCHAR)\\s*\\(\\s*\\d+\\s*\\)?\\s*\\)","to_char($2)")   // cast  ( xx123123_x  as  varchar(123) )
                .replaceAll("(cast|CAST)\\s*\\(\\s*([\\(\\)*%/'a-zA-Z0-9_\\.]+)\\s+as\\s+(numeric|NUMERIC)\\s*\\(\\s*\\d+\\s*,\\s*\\d+\\s*\\)\\s*\\)","to_number($2)") // cast(x123_xx  as  numeric(123,2) )
                //.replaceAll("(cast|CAST)\\s*\\(\\s*([\\(\\)*%/'a-zA-Z0-9_\\.]+)\\s+as\\s+(datetime|DATE|date|DATETIME)\\s*\\)","to_date($2,'yyyy-mm-dd hh24:mi:ss')")  //cast (xx123123_x as DATETIME )
                //剔除 sysdate对dateadd转换影响
                .replaceAll("(dateadd|DATEADD)\\s*\\(\\s*(month|m|MONTH|M|mm|MM)\\s*,\\s*(\\-?\\d*)\\s*,\\s*(sysdate|SYSDATE)\\s*\\)",
                        " sysdate+numtoyminterval($3,'month')")
                .replaceAll("(dateadd|DATEADD)\\s*\\(\\s*(yy|YY|year|YEAR)\\s*,\\s*(\\-?\\d*)\\s*,\\s*(sysdate|SYSDATE)\\s*\\)",
                        " sysdate+numtoyminterval($3,'year')")
                //剔除 sysdate 对datediff影响
                .replaceAll("(datediff|DATEDIFF)\\s*\\(\\s*(dd|d|day|D|DD|DAY)\\s*,\\s*(sysdate|SYSDATE)\\s*,\\s*((['a-zA-Z0-9_\\.]+)|([']?\\d{4}-\\d{2}-\\d{2}\\s{1}\\d{2}:\\d{2}:\\d{2}[']?))\\s*\\)",
                        " floor( cast($4 as date)  - cast(sysdate as date)) ")
                .replaceAll("(datediff|DATEDIFF)\\s*\\(\\s*(dd|d|day|D|DD|DAY)\\s*,\\s*((['a-zA-Z0-9_\\.]+)|([']?\\d{4}-\\d{2}-\\d{2}\\s{1}\\d{2}:\\d{2}:\\d{2}[']?))\\s*,\\s*(sysdate|SYSDATE)\\s*\\)",
                        " floor( cast(sysdate as date)  - cast($3 as date)) ")
                .replaceAll("(datediff|DATEDIFF)\\s*\\(\\s*(MM|m|mm|M|month|MONTH)\\s*,\\s*(sysdate|SYSDATE)\\s*,\\s*((['a-zA-Z0-9_\\.]+)|([']?\\d{4}-\\d{2}-\\d{2}\\s{1}\\d{2}:\\d{2}:\\d{2}[']?))\\s*\\)",
                        " EXTRACT(month from $4) - EXTRACT(month from sysdate) ")
                .replaceAll("(datediff|DATEDIFF)\\s*\\(\\s*(MM|m|mm|M|month|MONTH)\\s*,\\s*((['a-zA-Z0-9_\\.]+)|([']?\\d{4}-\\d{2}-\\d{2}\\s{1}\\d{2}:\\d{2}:\\d{2}[']?))\\s*,\\s*(sysdate|SYSDATE)\\s*\\)",
                        " EXTRACT(month from sysdate) - EXTRACT(month from $3) ")
                //对datediff dateadd处理 datediff(dd|mm,f_input_date,f_input_date)
                .replaceAll("(datediff|DATEDIFF)\\s*\\(\\s*(dd|d|day|D|DD|DAY)\\s*,\\s*(['a-zA-Z0-9_\\.]+)\\s*,\\s*(['a-zA-Z0-9_\\.]+)\\s*\\)",
                        " floor( cast($4 as date)  - cast($3 as date)) ")
                .replaceAll("(datediff|DATEDIFF)\\s*\\(\\s*(dd|d|day|D|DD|DAY)\\s*,\\s*([']?\\d{4}-\\d{2}-\\d{2}\\s{1}\\d{2}:\\d{2}:\\d{2}[']?)\\s*,\\s*([']?\\d{4}-\\d{2}-\\d{2}\\s{1}\\d{2}:\\d{2}:\\d{2}[']?)\\s*\\)",
                        " floor( cast($4 as date)  - cast($3 as date)) ")
                .replaceAll("(datediff|DATEDIFF)\\s*\\(\\s*(dd|d|day|D|DD|DAY)\\s*,\\s*([']?\\d{4}-\\d{2}-\\d{2}\\s{1}\\d{2}:\\d{2}:\\d{2}[']?)\\s*,\\s*(['a-zA-Z0-9_\\.]+)\\s*\\)",
                        " floor( cast($4 as date)  - cast($3 as date)) ")
                .replaceAll("(datediff|DATEDIFF)\\s*\\(\\s*(dd|d|day|D|DD|DAY)\\s*,\\s*(['a-zA-Z0-9_\\.]+)\\s*,\\s*([']?\\d{4}-\\d{2}-\\d{2}\\s{1}\\d{2}:\\d{2}:\\d{2}[']?)\\s*\\)",
                        " floor( cast($4 as date)  - cast($3 as date)) ")
                .replaceAll("(datediff|DATEDIFF)\\s*\\(\\s*(MM|m|mm|M|month|MONTH)\\s*,\\s*(['a-zA-Z0-9_\\.]+)\\s*,\\s*(['a-zA-Z0-9_\\.]+)\\s*\\)",
                        " EXTRACT(month from $4) - EXTRACT(month from $3) ")
                .replaceAll("(datediff|DATEDIFF)\\s*\\(\\s*(MM|m|mm|M|month|MONTH)\\s*,\\s*([']?\\d{4}-\\d{2}-\\d{2}\\s{1}\\d{2}:\\d{2}:\\d{2}[']?)\\s*,\\s*([']?\\d{4}-\\d{2}-\\d{2}\\s{1}\\d{2}:\\d{2}:\\d{2}[']?)\\s*\\)",
                        " EXTRACT(month from $4) - EXTRACT(month from $3) ")
                .replaceAll("(datediff|DATEDIFF)\\s*\\(\\s*(MM|m|mm|M|month|MONTH)\\s*,\\s*([']?\\d{4}-\\d{2}-\\d{2}\\s{1}\\d{2}:\\d{2}:\\d{2}[']?)\\s*,\\s*(['a-zA-Z0-9_\\.]+)\\s*\\)",
                        " EXTRACT(month from $4) - EXTRACT(month from $3) ")
                .replaceAll("(datediff|DATEDIFF)\\s*\\(\\s*(MM|m|mm|M|month|MONTH)\\s*,\\s*(['a-zA-Z0-9_\\.]+)\\s*,\\s*([']?\\d{4}-\\d{2}-\\d{2}\\s{1}\\d{2}:\\d{2}:\\d{2}[']?)\\s*\\)",
                        " EXTRACT(month from $4) - EXTRACT(month from $3) ")

                //dateadd(money|m|mm,-1,xxx)
                .replaceAll("(dateadd|DATEADD)\\s*\\(\\s*(month|m|MONTH|M|mm|MM)\\s*,\\s*(\\-?\\d*)\\s*,\\s*([0-9a-zA-Z_\\-\\s:\\.]+)\\s*\\)",
                        "to_date($4,'yyyy-mm-dd hh24:mi:ss')+numtoyminterval($3,'month')")
                .replaceAll("(dateadd|DATEADD)\\s*\\(\\s*(month|m|MONTH|M|mm|MM)\\s*,\\s*(\\-?\\d*)\\s*,\\s*([']?\\d{4}-\\d{2}-\\d{2}\\s{1}\\d{2}:\\d{2}:\\d{2}[']?)\\s*\\)",
                        "$4 + numtoyminterval($3,'month')")
                .replaceAll("(dateadd|DATEADD)\\s*\\(\\s*(yy|YY|year|YEAR)\\s*,\\s*(\\-?\\d*)\\s*,\\s*([0-9a-zA-Z_\\-\\s:\\.]+)\\s*\\)",
                        "to_date($4,'yyyy-mm-dd hh24:mi:ss')+numtoyminterval($3,'year')")
                .replaceAll("(dateadd|DATEADD)\\s*\\(\\s*(yy|YY|year|YEAR)\\s*,\\s*(\\-?\\d*)\\s*,\\s*([']?\\d{4}-\\d{2}-\\d{2}\\s{1}\\d{2}:\\d{2}:\\d{2}[']?)\\s*\\)",
                        "$4 + numtoyminterval($3,'year')")
                //剔除sysdate对datename处理
                .replaceAll("(datename|DATENAME)\\s*\\(\\s*(yy|YY|mm|MM|)\\s*,\\s*(sysdate|SYSDATE)\\s*\\)","to_char($3,'$2')")
                //对datename处理
                .replaceAll("(datename|DATENAME)\\s*\\(\\s*(yy|YY|mm|MM|)\\s*,\\s*([0-9a-zA-Z_\\-\\s:\\.]+)\\s*\\)","to_char($3,'$2')")
                .replaceAll("(datename|DATENAME)\\s*\\(\\s*(yy|YY|mm|MM|)\\s*,\\s*([']?\\d{4}-\\d{2}-\\d{2}\\s{1}\\d{2}:\\d{2}:\\d{2}[']?)\\s*\\)","to_char(to_date($3),'$2')")
                //剔除sysdate对DATEPART处理
                .replaceAll("(datepart|DATEPART)\\s*\\(\\s*(mM|mm|MM|)\\s*,\\s*(sysdate|SYSDATE)\\s*\\)","to_char($3,'mm')")
                //对datename处理
                .replaceAll("(datepart|DATEPART)\\s*\\(\\s*(mM|mm|MM|)\\s*,\\s*([0-9a-zA-Z_\\-\\s:\\.]+)\\s*\\)","to_char($3,'mm')")
                .replaceAll("(datepart|DATEPART)\\s*\\(\\s*(mM|mm|MM|)\\s*,\\s*([']?\\d{4}-\\d{2}-\\d{2}\\s{1}\\d{2}:\\d{2}:\\d{2}[']?)\\s*\\)","to_char(to_date($3),'mm')")


                //对字符串时间进行处理
                .replaceAll("([']?\\d{4}-\\d{2}-\\d{2}\\s{1}\\d{2}:\\d{2}:\\d{2}[']?)","to_date($1,'yyyy-mm-dd hh24:mi:ss')")  // 2021-01-22 00:00:00
                .replaceAll("([^\\s^>^<^=]+)(\\s*(>=|=|<=|>|<)\\s*(to_date|TO_DATE)\\((\\s*['0-9a-zA-Z_\\-\\s:\\.]+\\s*))(\\))"," to_date($1,'yyyy-mm-dd hh24:mi:ss') $2,'yyyy-mm-dd hh24:mi:ss'$6")
                .replaceAll("((to_date|TO_DATE)\\(\\s*['0-9a-zA-Z_\\-\\s:\\.]+\\s*)(\\))(\\s*(>=|=|<=|>|<)\\s?)([^\\s^>^<^=]+)"," $1,'yyyy-mm-dd hh24:mi:ss'$3 $4 to_date($6,'yyyy-mm-dd hh24:mi:ss')")
                .replaceAll("(with\\(nolock\\)|WITH\\(NOLOCK\\)|with\\(updlock,rowlock\\)|WITH\\(UPDLOCK,ROWLOCK\\))","")
                .replaceAll("([']?\\d{4}-\\d{2}-\\d{2}[']+)","to_date($1,'yyyy-mm-dd hh24:mi:ss')")  // 2021-01-22

        ;

        if(!isLockNessMonster(sql)){
            sql = sql+" from dual";
        }
        return sql;
    }

    /**
     * 验证是否存在某个字符串
     * @param checkstr
     * @param str
     * @return
     */
    private boolean isLockNessMonster(String str){
        if(str.matches("([\\s\\S]*)(create|Create|CREATE|insert|update|UPDATE|INSERT|DELETE|delete)([\\s\\S]*)")){
            return true;
        }
        return str.matches("([\\s\\S]*)(from|FROM)([\\s\\S]*)");
    }

    public static void main(String[] args) {
        OracleDialect oracleDialect = new OracleDialect();
        String sql = " select '2021-02-01' aa '2021-03-02 00:00:00' bb  ";
       // String sql = "select convert(varchar,t.h,23) ";
//cast(to_number(case when count(*)=0 then 0.00 else sum(f_yijian)/(count(0)+0.00)*100.00 end)  as varchar) + '%'  f_check_bv,
        boolean lockNessMonster = oracleDialect.isLockNessMonster(sql);
        String s =oracleDialect.getSql(sql);
        System.out.println(s);
    }

}
