package com.aote.transaction;

import com.af.plugins.RestTools;
import org.springframework.stereotype.Component;

// 用于手机端测试，向后台服务发起Session请求
@Component
public class ClientSession {
    // 后台服务地址
    private String url;
    // 从后台获取的Session号
    public String sessionId;

    // 开始事务，获取sessionId
    // url: 后端服务入口url
    public void begin(String url) {
        this.url = url;
        this.sessionId = RestTools.get(url + "/rs/trans");
    }

    // 回滚事务
    public void rollback() {
        RestTools.get(this.url + "/rs/trans/rollback/" + this.sessionId);
    }
}
