package com.aote.queryparams;

import java.util.stream.Stream;

/**
 * 查询类型
 * @author Mr.river
 */
public enum QueryTypeEnum {
    //相等
    EQUALS("="),
    //不等于
    NO_EQUALS("!="),
    //全模糊
    INNER_LIKE("LIKE"),
    //左模糊
    LEFT_LIKE("LEFT_LIKE"),
    //右模糊
    RIGHT_LIKE("RIGHT_LIKE"),
    //大于
    GREATER_THAN(">"),
    //大于等于
    GREATER_THAN_EQUALS(">="),
    //小于
    LESS_THAN("<"),
    //小于等于
    LESS_THAN_EQUALS("<="),
    //包含
    IN("IN"),
    //不包含
    NOT_IN("NOT_IN"),
    //之间
    BETWEEN("BETWEEN");

    private final String value;

    QueryTypeEnum(String value) {
        this.value = value;
    }

    public static QueryTypeEnum toType(String value) {
        return Stream.of(QueryTypeEnum.values())
                .filter(p -> p.value.equals(value))
                .findAny()
                .orElse(null);
    }

    public static boolean is(String value){
        return toType(value) != null;
    }

    public String getValue(){
        return value;
    }
}
