/*
 * Decompiled with CFR 0.152.
 */
package com.aote.queryparams;

import com.aote.ThreadResource;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.log4j.Logger;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;

public class QueryParamsMapper {
    private static final Logger LOGGER = Logger.getLogger(QueryParamsMapper.class);
    private static Map<String, Map<String, String>> map;

    public static String getQueryParams(String alias) {
        if (map.containsKey(alias)) {
            String result = QueryParamsMapper.getQueryParamsByUser(alias);
            if (result != null) {
                return result;
            }
            return map.get(alias).get("path");
        }
        return null;
    }

    public static Map<String, Map<String, String>> getMap() {
        return map;
    }

    public static String getQueryParamsByUser(String alias) {
        String dir = ThreadResource.ComponentDir.get();
        if (dir == null) {
            return null;
        }
        String path = dir + "/queryparams/" + alias + ".json";
        return QueryParamsMapper.class.getClassLoader().getResourceAsStream(path) != null ? path : null;
    }

    private static void loadMap() {
        map = new HashMap<String, Map<String, String>>();
        SAXReader reader = new SAXReader();
        InputStream module = QueryParamsMapper.class.getClassLoader().getResourceAsStream("module.xml");
        try {
            InputStream input;
            if (module != null) {
                QueryParamsMapper.parseModule(module);
            }
            if ((input = QueryParamsMapper.class.getClassLoader().getResourceAsStream("queryparams.xml")) != null) {
                Document document = reader.read(input);
                Element root = document.getRootElement();
                Iterator it = root.elementIterator("queryparams");
                while (it.hasNext()) {
                    Element elm = (Element)it.next();
                    HashMap<String, String> queryparams = new HashMap<String, String>();
                    String alias = elm.attribute("alias").getValue();
                    queryparams.put("alias", alias);
                    String path = elm.attribute("path").getValue();
                    queryparams.put("path", "queryparams/" + path);
                    String mobile = elm.attributeValue("mobile");
                    queryparams.put("mobile", mobile);
                    map.put(alias, queryparams);
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private static void parseModule(InputStream input) throws Exception {
        SAXReader reader = new SAXReader();
        Document document = reader.read(input);
        Element root = document.getRootElement();
        Iterator it = root.elementIterator("module");
        while (it.hasNext()) {
            Element elm = (Element)it.next();
            String name = elm.attribute("name").getValue();
            String path = elm.attributeValue("path");
            QueryParamsMapper.putMap(name, reader, path);
            Iterator children = elm.elementIterator("module");
            while (children.hasNext()) {
                Element childElm = (Element)children.next();
                String childname = childElm.attribute("name").getValue();
                QueryParamsMapper.putMap(childname, reader, name);
            }
        }
    }

    private static void putMap(String name, SAXReader reader, String parent) throws Exception {
        InputStream module = QueryParamsMapper.class.getClassLoader().getResourceAsStream(parent == null ? name + "/queryparams.xml" : parent + "/" + name + "/queryparams.xml");
        if (module != null) {
            Document doc = reader.read(module);
            Element root = doc.getRootElement();
            Iterator item = root.elementIterator("queryparams");
            while (item.hasNext()) {
                Element elmment = (Element)item.next();
                HashMap<String, String> params = new HashMap<String, String>();
                String alias = elmment.attribute("alias").getValue();
                params.put("alias", alias);
                String path = elmment.attribute("path").getValue();
                params.put("path", (parent == null ? name + "/queryparams/" : parent + "/" + name + "/queryparams/") + path);
                String mobile = elmment.attributeValue("mobile");
                params.put("mobile", mobile);
                if (map.containsKey(alias)) {
                    throw new Exception("\u522b\u540d" + alias + "\u5df2\u5b58\u5728");
                }
                map.put(alias, params);
            }
        }
    }

    static {
        QueryParamsMapper.loadMap();
    }
}

