/*
 * Decompiled with CFR 0.152.
 */
package com.aote.filter;

import com.aote.filter.Config;
import com.aote.filter.RSAUtil;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class DesensitizationTool {
    public static final String KEY = "7xjgtQc4M8FOXikU7JkwcUI0wKhYkREt";

    public static void main(String[] args) throws Exception {
    }

    public static boolean checkID(String id) {
        String regex = "(^\\d{15}$)|(^\\d{18}$)|(^\\d{17}(\\d|X|x)$)";
        return id.matches(regex);
    }

    public static boolean checkPhone(String phone) {
        String regex = "^(13[0-9]|14[5-9]|15[012356789]|16[56]|17[0-8]|18[0-9]|19[189])\\d{8}$";
        return phone.matches(regex);
    }

    public static String phoneEncrypt(String phone) throws Exception {
        if (!Config.isDesensitization()) {
            return phone;
        }
        String regex = "(\\d{3})(\\d{4})(\\d{4})";
        Pattern pattern = Pattern.compile(regex);
        Matcher matcher = pattern.matcher(phone);
        String encrypt = "";
        if (matcher.find()) {
            String group1 = matcher.group(2);
            encrypt = RSAUtil.aesEncrypt(group1, KEY);
        }
        encrypt = "|-" + encrypt + "-|";
        return phone.replaceAll(regex, "$1" + encrypt + "$3");
    }

    public static String idNumberEncrypt(String idNumber) throws Exception {
        if (!Config.isDesensitization()) {
            return idNumber;
        }
        String regex = "^(\\d*)(\\w{4})$";
        Pattern pattern = Pattern.compile(regex);
        Matcher matcher = pattern.matcher(idNumber);
        String encrypt = "";
        if (matcher.find()) {
            String group1 = matcher.group(1);
            encrypt = RSAUtil.aesEncrypt(group1, KEY);
        }
        encrypt = "|-" + encrypt + "-|";
        return idNumber.replaceAll(regex, encrypt + "$2");
    }
}

