/*
 * Decompiled with CFR 0.152.
 */
package com.aote.redis;

import com.af.plugins.JsonTools;
import com.aote.redis.RedisService;
import com.aote.rs.mapper.WebException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;
import org.json.JSONArray;
import org.json.JSONObject;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.connection.jedis.JedisConnectionFactory;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.core.script.DefaultRedisScript;
import org.springframework.data.redis.core.script.RedisScript;
import org.springframework.data.redis.serializer.GenericToStringSerializer;
import org.springframework.data.redis.serializer.RedisSerializer;
import org.springframework.data.redis.serializer.StringRedisSerializer;
import org.springframework.stereotype.Component;
import redis.clients.jedis.JedisPoolConfig;

@Component
public class RedisUtil
implements RedisService {
    private static RedisTemplate<String, Object> redisTemplate;
    private static Logger log;
    private static RedisScript<Boolean> lockScript;

    @Override
    public Boolean has(String key) {
        return redisTemplate.hasKey((Object)key);
    }

    @Override
    public void set(String key, Object value) {
        this.set(key, value, -1L);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void set(String key, Object value, long timeoutSec) {
        if (this.has(key).booleanValue()) {
            if (!this.lock(key, 10L).booleanValue()) {
                log.error((Object)"\u4fee\u6539\u5931\u8d25\uff0c\u8be5\u6570\u636e\u53d7\u9501\u4fdd\u62a4\u4e2d\u3002");
                throw new WebException(505, "\u4fee\u6539\u5931\u8d25\uff0c\u8be5\u6570\u636e\u53d7\u9501\u4fdd\u62a4\u4e2d\u3002");
            }
            if (timeoutSec == -1L) {
                redisTemplate.opsForValue().set((Object)key, value);
            } else {
                redisTemplate.opsForValue().set((Object)key, value, timeoutSec);
            }
            this.unLock(key);
            return;
        }
        if (timeoutSec == -1L) {
            redisTemplate.opsForValue().set((Object)key, value);
            return;
        }
        redisTemplate.opsForValue().set((Object)key, value, timeoutSec);
    }

    @Override
    public void setHash(String hashKey, JSONObject value) {
        this.setHash(hashKey, value.toMap());
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void setHash(String hashKey, Map<String, Object> value) {
        if (!this.has(hashKey).booleanValue()) {
            redisTemplate.opsForHash().putAll((Object)hashKey, value);
            return;
        }
        if (this.lock(hashKey, 10L).booleanValue()) {
            redisTemplate.opsForHash().putAll((Object)hashKey, value);
            this.unLock(hashKey);
            return;
        }
        log.error((Object)"\u4fee\u6539\u5931\u8d25\uff0c\u8be5\u6570\u636e\u53d7\u9501\u4fdd\u62a4\u4e2d\u3002");
        throw new WebException(505, "\u4fee\u6539\u5931\u8d25\uff0c\u8be5\u6570\u636e\u53d7\u9501\u4fdd\u62a4\u4e2d\u3002");
    }

    @Override
    public JSONObject getHash(String hashKey) {
        return new JSONObject(redisTemplate.opsForHash().entries((Object)hashKey));
    }

    @Override
    public Object getHash(String hashKey, String key) {
        return redisTemplate.opsForHash().get((Object)hashKey, (Object)key);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void setHashKey(String hashKey, String key, Object value) {
        if (!this.hasHashKey(hashKey, key).booleanValue()) {
            redisTemplate.opsForHash().put((Object)key, (Object)hashKey, value);
            return;
        }
        if (this.hashLock(hashKey, key, 10L).booleanValue()) {
            redisTemplate.opsForHash().put((Object)key, (Object)hashKey, value);
            this.hashUnLock(hashKey, key);
            return;
        }
        log.error((Object)"\u4fee\u6539\u5931\u8d25\uff0c\u8be5\u6570\u636e\u53d7\u9501\u4fdd\u62a4\u4e2d\u3002");
        throw new WebException(505, "\u4fee\u6539\u5931\u8d25\uff0c\u8be5\u6570\u636e\u53d7\u9501\u4fdd\u62a4\u4e2d\u3002");
    }

    @Override
    public void deleteHashKey(String hashKey, String key) {
        redisTemplate.opsForHash().delete((Object)hashKey, new Object[]{key});
    }

    @Override
    public Boolean hasHashKey(String hashKey, String key) {
        return redisTemplate.opsForHash().hasKey((Object)hashKey, (Object)key);
    }

    @Override
    public Boolean lock(String key, long timeoutSec) {
        return this.setIfAbsent(key + "-lock", "lock", timeoutSec);
    }

    @Override
    public Boolean hashLock(String hashKey, String key, long timeoutSec) {
        return this.setIfAbsent(hashKey + "-" + key + "-lock", "lock", timeoutSec);
    }

    @Override
    public void unLock(String key) {
        this.delete(key + "-lock");
    }

    @Override
    public void hashUnLock(String hashKey, String key) {
        this.delete(hashKey + "-" + key + "-lock");
    }

    @Override
    public void rename(String oldKey, String newKey) {
        redisTemplate.rename((Object)oldKey, (Object)newKey);
    }

    @Override
    public Object get(String key) {
        return redisTemplate.opsForValue().get((Object)key);
    }

    @Override
    public void delete(String key) {
        redisTemplate.delete((Object)key);
    }

    @Override
    public void deleteList(Set<String> keys) {
        redisTemplate.delete(keys);
    }

    @Override
    public void deleteList(JSONArray keys) {
        HashSet<String> keySet = new HashSet<String>(keys.length());
        for (int i = 0; i < keys.length(); ++i) {
            keySet.add(keys.getString(i));
        }
        this.deleteList(keySet);
    }

    @Override
    public void deleteList(JSONObject keys) {
        this.deleteList(keys.keySet());
    }

    public boolean setIfAbsent(String key, String value, long seconds) {
        ArrayList<String> keys = new ArrayList<String>();
        keys.add(key);
        return (Boolean)redisTemplate.execute(lockScript, keys, new Object[]{value, String.valueOf(seconds)});
    }

    static {
        log = Logger.getLogger(RedisUtil.class);
        String newSetIfAbsentScriptStr = " if 1 == redis.call('setnx',KEYS[1],ARGV[1]) then redis.call('expire',KEYS[1],ARGV[2]) return 1; else return 0; end;";
        lockScript = new DefaultRedisScript(newSetIfAbsentScriptStr, Boolean.class);
        JSONObject redisConfigMap = null;
        if (RedisUtil.class.getClassLoader().getResourceAsStream("/redisConfig.json") != null) {
            redisConfigMap = JsonTools.readJsonFile((String)"/redisConfig.json");
        }
        JedisPoolConfig poolConfig = new JedisPoolConfig();
        poolConfig.setMaxIdle(200);
        poolConfig.setMaxTotal(1024);
        poolConfig.setMaxWaitMillis(1000L);
        poolConfig.setTestOnBorrow(true);
        poolConfig.setTestOnReturn(true);
        JedisConnectionFactory factory = new JedisConnectionFactory(poolConfig);
        if (redisConfigMap != null) {
            factory.setHostName(redisConfigMap.getString("hostName"));
            if (redisConfigMap.has("password")) {
                factory.setPassword(redisConfigMap.getString("password"));
            }
            factory.setPort(redisConfigMap.getInt("port"));
        } else {
            factory.setHostName("127.0.0.1");
            factory.setPort(6379);
        }
        factory.afterPropertiesSet();
        redisTemplate = new RedisTemplate();
        redisTemplate.setConnectionFactory((RedisConnectionFactory)factory);
        GenericToStringSerializer genericToStringSerializer = new GenericToStringSerializer(Object.class);
        redisTemplate.setValueSerializer((RedisSerializer)genericToStringSerializer);
        redisTemplate.setKeySerializer((RedisSerializer)new StringRedisSerializer());
        redisTemplate.afterPropertiesSet();
    }
}

