package com.aote.manager;

import org.json.JSONArray;
import org.json.JSONObject;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class VueServer {
	private Pattern pattern = Pattern.compile("'([^']*)'");

	public JSONArray getData() {
		JSONArray result = new JSONArray();
		
		InputStream input = VueServer.class.getClassLoader().getResourceAsStream("main.js");
		try {
			// 保存找到的最近的未匹配内容的注释
			JSONObject item = null;
			
			// 一行行读取信息
			BufferedReader reader = new BufferedReader(new InputStreamReader(input, StandardCharsets.UTF_8));
			String line = reader.readLine();
			while (line != null) {
				// 如果是注释，对注释进行处理
				if (line.startsWith("//")) {
					JSONObject json = this.getJSON(line);
					if (json != null) {
						item = json;
					}
				} 
				// 是节点，对节点进行处理
				else if (line.startsWith("Vue.component('")) {
					// 如果没有注释，产生空注释
					if (item == null) {
						item = new JSONObject();
						item.put("summery", "");
					}
					this.procElement(line, item);
					result.put(item);
					item = null;
				}
				line = reader.readLine();
			}

			return result;
		} catch (Exception ex) {
			throw new RuntimeException(ex);
		}
	}
	
	// 对注释进行处理，从注释中获取说明，注释以 '//' 开始
	private JSONObject getJSON(String text) {
		JSONObject result = new JSONObject();
		// 读去 '//'
		result.put("summery", text.substring(2));
		return result;
	}
	
	// 对找到的节点进行处理, 向注释对应的JSON中添加名称及内容
	private void procElement(String text, JSONObject json) {
		// 用正则表达式找到名称和路径
		Matcher matcher = pattern.matcher(text);
		if (matcher.find()) {
			String name = matcher.group(1);
			json.put("name", name);
		} else {
			json.put("name", "");
		}
		if (matcher.find()) {
			String path = matcher.group(1);
			json.put("text", "路径: " + path);
		} else {
			json.put("text", "");
		}
	}
}
