package com.aote.util;

/**
 * SQL运行时支持
 */
public class SQLRuntimeSupport {
    /**
     * 标准结果转换器（实现SQL执行结果列有序）
     */
    private static final ThreadLocal<Boolean> standardTransformerThreadLocal = new ThreadLocal<>();

    public static boolean getStandardTransformerValue() {
        Boolean yn = standardTransformerThreadLocal.get();
        return yn != null && yn;
    }

    public static void openStandardTransformer() {
        standardTransformerThreadLocal.set(true);
    }

    public static void closeStandardTransformer() {
        standardTransformerThreadLocal.remove();
    }
}
