/*
 * Decompiled with CFR 0.152.
 */
package com.aote.excel.core;

import com.alibaba.excel.metadata.Head;
import com.alibaba.excel.metadata.data.WriteCellData;
import com.alibaba.excel.util.StyleUtil;
import com.alibaba.excel.write.handler.CellWriteHandler;
import com.alibaba.excel.write.metadata.holder.WriteSheetHolder;
import com.alibaba.excel.write.metadata.holder.WriteTableHolder;
import com.alibaba.excel.write.metadata.style.WriteCellStyle;
import com.alibaba.excel.write.metadata.style.WriteFont;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.Workbook;

public class CellColorSheetWriteHandler
implements CellWriteHandler {
    private final HashMap<Integer, List<Integer>> map;
    private final Short fontColorIndex;
    private final Short fullColorIndex;

    public CellColorSheetWriteHandler(HashMap<Integer, List<Integer>> map, Short fontColorIndex, Short fullColorIndex) {
        this.map = map;
        this.fontColorIndex = fontColorIndex;
        this.fullColorIndex = fullColorIndex;
    }

    public void afterCellDispose(WriteSheetHolder writeSheetHolder, WriteTableHolder writeTableHolder, List<WriteCellData<?>> cellDataList, Cell cell, Head head, Integer relativeRowIndex, Boolean isHead) {
        int col = cell.getColumnIndex();
        int row = cell.getRowIndex();
        if (0 != row) {
            ArrayList integers = new ArrayList();
            if (this.map.get(-1) != null) {
                integers.addAll(this.map.get(-1));
            }
            if (this.map.get(row) != null) {
                integers.addAll(this.map.get(row));
            }
            if (integers.size() > 0 && (integers.contains(col) || integers.contains(-1))) {
                Workbook workbook = cell.getSheet().getWorkbook();
                WriteCellStyle contentCellStyle = new WriteCellStyle();
                contentCellStyle.setHorizontalAlignment(HorizontalAlignment.CENTER);
                contentCellStyle.setBorderBottom(BorderStyle.MEDIUM);
                contentCellStyle.setBorderLeft(BorderStyle.MEDIUM);
                contentCellStyle.setBorderRight(BorderStyle.MEDIUM);
                contentCellStyle.setBorderTop(BorderStyle.MEDIUM);
                WriteFont cellWriteFont = new WriteFont();
                cellWriteFont.setColor(this.fontColorIndex);
                contentCellStyle.setFillPatternType(FillPatternType.SOLID_FOREGROUND);
                contentCellStyle.setFillForegroundColor(this.fullColorIndex);
                contentCellStyle.setWriteFont(cellWriteFont);
                CellStyle cellStyle = StyleUtil.buildCellStyle((Workbook)workbook, (CellStyle)workbook.getCellStyleAt(0), (WriteCellStyle)contentCellStyle);
                cell.getRow().getCell(col).setCellStyle(cellStyle);
            }
        }
    }
}

