/*
 * Decompiled with CFR 0.152.
 */
package com.aote.logic;

import com.aote.config.SystemConfig;
import com.aote.entity.EntityServer;
import com.aote.exception.FileNotFoundException;
import com.aote.logic.LogicMapper;
import com.aote.logic.PluginMapper;
import com.aote.redis.RedisUtil;
import com.aote.rs.LogicService;
import com.aote.sql.SqlMapper;
import com.aote.sql.SqlServer;
import com.aote.transaction.SessionPool;
import com.aote.util.ExpressionHelper;
import com.aote.util.ResourceHelper;
import com.aote.util.ResourceType;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.transaction.Transactional;
import org.apache.log4j.Logger;
import org.json.JSONArray;
import org.json.JSONObject;
import org.json.JSONTokener;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Component;

@Component
@Transactional(rollbackOn={Exception.class})
public class LogicServer {
    static Logger log = Logger.getLogger(LogicServer.class);
    @Autowired
    private EntityServer entityServer;
    @Autowired
    private SqlServer sqlServer;
    @Autowired
    private SessionPool sessionPool;

    public boolean has(String name) {
        String path = LogicMapper.getLogic(name);
        return path != null;
    }

    public Object run(String name, String str) {
        JSONObject param = null;
        if ((str = str.trim()).startsWith("<") && str.endsWith(">")) {
            param = new JSONObject();
            param.put("xml", (Object)str);
        } else {
            Object json = new JSONTokener(str).nextValue();
            if (json instanceof JSONObject) {
                Object dataParam;
                param = new JSONObject(str);
                if (!param.isNull("data") && (dataParam = param.get("data")) instanceof JSONObject) {
                    param = (JSONObject)dataParam;
                    param.put("standardData", (Object)new JSONObject(str).toString());
                }
            } else if (json instanceof JSONArray) {
                param = new JSONObject();
                param.put("arr", (Object)new JSONArray(str));
            }
        }
        return this.run(name, param);
    }

    public Object run(String name, JSONObject param) {
        Object reviewArray;
        String source;
        boolean isEnableCache = LogicMapper.isEnableCache(name);
        String message = "\u7ef4\u62a4\u4fe1\u606f:\u5f00\u59cb\u6267\u884cLogic[" + name + "]\uff0c\u7f13\u5b58\uff1a" + isEnableCache + "\uff0c\u53c2\u6570\uff1a" + String.valueOf(param);
        log.debug((Object)message);
        String path = LogicMapper.getLogic(name);
        if (path == null) {
            throw new RuntimeException("\u4e1a\u52a1\u903b\u8f91\u672a\u627e\u5230: " + name);
        }
        try {
            source = (String)ResourceHelper.getString(ResourceType.LOGIC, name, path);
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException(path + ".\u6587\u4ef6\u65e0\u914d\u7f6e");
        }
        catch (IOException io) {
            throw new RuntimeException(io);
        }
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("data", param);
        params.put("log", log);
        params.put("entity", this.entityServer);
        params.put("sql", this.sqlServer);
        params.put("session", this.sessionPool.getSession());
        params.put("redis", RedisUtil.getInstance());
        params.put("logic", this);
        Map<String, Object> plugins = PluginMapper.getPlugins();
        params.putAll(plugins);
        long begin = System.currentTimeMillis();
        String reviewKey = LogicService.reviewKey.get();
        JSONObject reviewItem = new JSONObject();
        if (reviewKey != null && (reviewArray = LogicService.reviewCache.get(reviewKey)) != null) {
            reviewItem.put("bTime", begin);
            reviewItem.put("name", (Object)name);
            reviewItem.put("type", (Object)"logic");
            reviewArray.put((Object)reviewItem);
        }
        try {
            Object result = ExpressionHelper.run(source, params);
            reviewItem.put("status", 0);
            reviewArray = result;
            return reviewArray;
        }
        catch (Exception e) {
            reviewItem.put("status", -1);
            throw e;
        }
        finally {
            long end = System.currentTimeMillis();
            long time = end - begin;
            String engMessage = "\u7ef4\u62a4\u4fe1\u606f:\u6267\u884cLogic[" + name + "]\u8017\u65f6:" + time;
            if (time >= 8000L) {
                log.error((Object)engMessage);
            } else if (time >= 4000L) {
                log.warn((Object)engMessage);
            } else {
                log.debug((Object)engMessage);
            }
            reviewItem.put("eTime", end);
            reviewItem.put("constTime", time);
        }
    }

    @Async(value="AsyncLogicGet")
    public void runAsync(String logicName, String values) {
        this.run(logicName, values);
    }

    public void redisCacheLogic() {
        if (SystemConfig.Redis.hasHostName() && SystemConfig.Redis.hasRegisterUrl()) {
            RedisUtil redisUtil = RedisUtil.getInstance();
            String url = SystemConfig.Redis.getRegisterUrl();
            Map<String, Map<String, String>> map = LogicMapper.getMap();
            if (map != null) {
                for (String key : map.keySet()) {
                    redisUtil.set(key, url);
                    log.info((Object)("logic\u52a0\u5165redis\u7f13\u5b58\uff0ckey=" + key + ", value=" + url));
                }
            }
            if ((map = SqlMapper.getMap()) != null) {
                for (String key : map.keySet()) {
                    redisUtil.set(key, url);
                    log.info((Object)("sql\u52a0\u5165redis\u7f13\u5b58\uff0ckey=" + key + ", value=" + url));
                }
            }
        }
    }
}

