package com.aote.util;

import java.util.stream.Stream;

/**
 * 资源类型
 * @author Mr.river
 */
public enum ResourceType {
    /**
     * LOGIC文件
     */
    LOGIC("logic"),
    /**
     * SQL文件
     */
    SQL("sql"),
    /**
     * PATH文件
     */
    PATH("path"),
    /**
     * 查询参数文件
     */
    QUERY_PARAMS("query_params");

    private final String value;

    ResourceType(String value) {
        this.value = value;
    }

    public static ResourceType toType(String value) {
        return Stream.of(ResourceType.values())
                .filter(p -> p.value.equals(value))
                .findAny()
                .orElse(null);
    }

    public static boolean is(String value){
        return toType(value) != null;
    }

    public String getValue(){
        return value;
    }
}
