package com.aote.sql;

import cn.hutool.core.date.DateUtil;
import com.aote.util.ClobUtil;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.hibernate.transform.AliasedTupleSubsetResultTransformer;
import org.json.JSONObject;

import java.math.BigDecimal;
import java.sql.Clob;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.Map;

/**
 * 标准结果转换器
 */
public class StandardAliasTransformer extends AliasedTupleSubsetResultTransformer {

    private static final Logger logManager = LogManager.getLogger(StandardAliasTransformer.class);

    public static final StandardAliasTransformer INSTANCE = new StandardAliasTransformer();

    /**
     * Disallow instantiation of AliasToEntityMapResultTransformer.
     */
    private StandardAliasTransformer() {
    }

    protected static void runTrans(Object obj, Object[] tuple, String[] aliases) {
        for (int i = 0; i < aliases.length; i++) {
            String alias = aliases[i];
            Object value = tuple[i];
            if (alias != null) {
                if (value instanceof BigDecimal) {
                    BigDecimal valueObj = (BigDecimal) value;
                    if (isIntegerValue(valueObj)) {
                        long longValue = valueObj.longValue();
                        if (longValue < Integer.MAX_VALUE) {
                            value = (int) longValue;
                        } else {
                            value = longValue;
                        }
                    }
                } else if (value instanceof Date) {
                    Date dateObj = (Date) value;
                    // 处理日期格式
                    value = DateUtil.formatDateTime(dateObj);
                } else if (value instanceof Clob) {
                    Clob clobObj = (Clob) value;
                    value = ClobUtil.getClobString(clobObj);
                }
                if (obj instanceof JSONObject) {
                    JSONObject object = (JSONObject) obj;
                    object.put(alias.toLowerCase(), value);
                } else if (obj instanceof Map<?, ?>) {
                    Map<String, Object> objectMap = (Map<String, Object>) obj;
                    objectMap.put(alias.toLowerCase(), value);
                }
            }
        }
    }

    private static boolean isIntegerValue(BigDecimal bd) {
        return bd.stripTrailingZeros().scale() <= 0;
    }

    @Override
    public Map<String, Object> transformTuple(Object[] tuple, String[] aliases) {
        Map<String, Object> objectMap = new LinkedHashMap<>(aliases.length);
        runTrans(objectMap, tuple, aliases);
        return objectMap;
    }

    @Override
    public boolean isTransformedValueATupleElement(String[] aliases, int tupleLength) {
        return false;
    }

    private Object readResolve() {
        return INSTANCE;
    }
}
