package com.aote.sql;

import cn.hutool.core.date.DateUtil;
import com.aote.util.ClobUtil;
import org.hibernate.transform.AliasedTupleSubsetResultTransformer;
import org.json.JSONObject;

import java.math.BigDecimal;
import java.sql.Clob;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.Map;

/**
 * 标准结果转换器
 */
public class StandardAliasTransformer extends AliasedTupleSubsetResultTransformer {

    public static final StandardAliasTransformer INSTANCE = new StandardAliasTransformer();

    /**
     * Disallow instantiation of AliasToEntityMapResultTransformer.
     */
    private StandardAliasTransformer() {
    }

    protected static void runTrans(Map<String, Object> obj, Object[] tuple, String[] aliases) {
        SimpleDateFormat SIMPLE_DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        for (int i = 0; i < aliases.length; i++) {
            String alias = aliases[i];
            Object value = tuple[i];
            if (alias != null) {
                if (value == null) {
                    value = JSONObject.NULL;
                } else if (value instanceof Date) {
                    // 处理日期格式
                    value = SIMPLE_DATE_FORMAT.format(value);
                } else if (value instanceof Clob) {
                    value = ClobUtil.getClobString((Clob) value);
                } else if (value instanceof BigDecimal) {
                    if (isIntegerValue((BigDecimal) value)) {
                        long longValue = ((BigDecimal) value).longValue();
                        if (longValue < Integer.MAX_VALUE) {
                            value = (int) longValue;
                        } else {
                            value = longValue;
                        }
                    }
                }
                obj.put(alias.toLowerCase(), value);
            }
        }
    }

    private static boolean isIntegerValue(BigDecimal bd) {
        return bd.stripTrailingZeros().scale() <= 0;
    }

    @Override
    public Map<String, Object> transformTuple(Object[] tuple, String[] aliases) {
        Map<String, Object> objectMap = new LinkedHashMap<>(aliases.length);
        runTrans(objectMap, tuple, aliases);
        return objectMap;
    }

    @Override
    public boolean isTransformedValueATupleElement(String[] aliases, int tupleLength) {
        return false;
    }

    private Object readResolve() {
        return INSTANCE;
    }
}
