package com.aote.sql;

import com.aote.util.ClobUtil;
import org.hibernate.transform.AliasedTupleSubsetResultTransformer;
import org.json.JSONObject;

import java.math.BigDecimal;
import java.sql.Clob;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public class AliasTransformer extends AliasedTupleSubsetResultTransformer {

	public static final AliasTransformer INSTANCE = new AliasTransformer();

	/**
	 * Disallow instantiation of AliasToEntityMapResultTransformer.
	 */
	private AliasTransformer() {
	}

	@Override
	public Object transformTuple(Object[] tuple, String[] aliases) {
		SimpleDateFormat SIMPLE_DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
		Map<String, Object> result = new HashMap<>(tuple.length);
		for ( int i = 0; i < aliases.length; i++ ) {
			String alias = aliases[i];
			if (alias != null) {
				Object value = tuple[i];
				if(value == null){
					value = JSONObject.NULL;
				} else if(value instanceof Date){
					value = SIMPLE_DATE_FORMAT.format(value);
				} else if (value instanceof Clob){
					value = ClobUtil.getClobString((Clob) value);
				} else if (value instanceof BigDecimal){
					if (isIntegerValue((BigDecimal) value)) {
						long longValue = ((BigDecimal) value).longValue();
						if (longValue < Integer.MAX_VALUE) {
							value = (int) longValue;
						} else {
							value = longValue;
						}
					}
				}
				result.put( alias.toLowerCase(), value);
			}
		}
		return result;
	}

	private static boolean isIntegerValue(BigDecimal bd) {
		return bd.stripTrailingZeros().scale() <= 0;
	}

	@Override
	public boolean isTransformedValueATupleElement(String[] aliases, int tupleLength) {
		return false;
	}

	/**
	 * Serialization hook for ensuring singleton uniqueing.
	 *
	 * @return The singleton instance : {@link #INSTANCE}
	 */
	private Object readResolve() {
		return INSTANCE;
	}
}
