/*
 * Decompiled with CFR 0.152.
 */
package com.aote.util;

import cn.hutool.cache.Cache;
import cn.hutool.cache.CacheUtil;
import com.aote.exception.FileNotFoundException;
import com.aote.util.ResourceType;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import org.springframework.stereotype.Component;

@Component
public class ResourceHelper {
    public static CACHE_MODE mode = CACHE_MODE.NORMAL;
    private static final Cache<String, String> LOGIC_CACHE = CacheUtil.newLRUCache((int)100);
    private static final Cache<String, String> SQL_CACHE = CacheUtil.newLRUCache((int)100);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getString(String fileName) throws FileNotFoundException, IOException {
        String result;
        InputStream inputStream = null;
        BufferedReader br = null;
        try {
            String line;
            if (!fileName.startsWith("/")) {
                fileName = "/" + fileName;
            }
            if (null == (inputStream = ResourceHelper.class.getResourceAsStream(fileName))) {
                throw new FileNotFoundException(fileName + "\u6587\u4ef6\u4e0d\u5b58\u5728", fileName);
            }
            br = new BufferedReader(new InputStreamReader(inputStream, StandardCharsets.UTF_8));
            StringBuilder sb = new StringBuilder();
            while ((line = br.readLine()) != null) {
                sb.append(line).append("\r\n");
            }
            result = sb.toString();
        }
        finally {
            if (null != inputStream) {
                inputStream.close();
            }
            if (br != null) {
                br.close();
            }
        }
        return result;
    }

    public static Object getString(ResourceType resourceType, String alias, String fileName) throws FileNotFoundException, IOException {
        String sourceStr = null;
        switch (resourceType) {
            case LOGIC: {
                if (mode == CACHE_MODE.NORMAL) {
                    sourceStr = (String)LOGIC_CACHE.get((Object)alias);
                }
                if (sourceStr == null) {
                    sourceStr = ResourceHelper.getString(fileName);
                    sourceStr = sourceStr.replace("\r\n", "\n");
                    if (mode == CACHE_MODE.NORMAL) {
                        LOGIC_CACHE.put((Object)alias, (Object)sourceStr);
                    }
                }
                return sourceStr;
            }
            case SQL: {
                if (mode == CACHE_MODE.NORMAL) {
                    sourceStr = (String)SQL_CACHE.get((Object)alias);
                }
                if (sourceStr == null) {
                    sourceStr = ResourceHelper.getString(fileName);
                    sourceStr = "$" + sourceStr.replace("\r\n", "\n");
                    if (mode == CACHE_MODE.NORMAL) {
                        SQL_CACHE.put((Object)alias, (Object)sourceStr);
                    }
                }
                return sourceStr;
            }
        }
        throw new RuntimeException("\u9519\u8bef\u7684\u7f13\u5b58\u6570\u636e\u7c7b\u578b");
    }

    public static void clearLogicCache() {
        LOGIC_CACHE.clear();
    }

    public static void clearSqlCache() {
        SQL_CACHE.clear();
    }

    public static enum CACHE_MODE {
        NORMAL,
        DEBUG;

    }
}

