/*
 * Decompiled with CFR 0.152.
 */
package com.aote.sql;

import com.af.util.Pair;
import com.aote.entity.EntityServer;
import com.aote.exception.FileNotFoundException;
import com.aote.sql.SqlMapper;
import com.aote.transaction.SessionPool;
import com.aote.util.ExpressionHelper;
import com.aote.util.JsonHelper;
import com.aote.util.ResourceHelper;
import com.aote.util.ResourceType;
import com.aote.util.SQLRuntimeSupport;
import com.aote.util.SqlHelper;
import java.io.File;
import java.io.IOException;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.transaction.Transactional;
import org.apache.log4j.Logger;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.json.JSONArray;
import org.json.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@Transactional
public class SqlServer {
    static Logger log = Logger.getLogger(SqlServer.class);
    @Autowired
    public SessionFactory sessionFactory;
    @Autowired
    private SessionPool sessionPool;
    @Autowired
    public EntityServer entityServer;
    public Session assignedSession;

    public SessionFactory getSessionFactory() {
        return this.sessionFactory;
    }

    public void setAssignedSession(Session session) {
        this.assignedSession = session;
    }

    public JSONObject queryTotal(String name, String str) throws Exception {
        JSONObject param = null;
        Object sums = null;
        if (str != null && !str.isEmpty()) {
            JSONObject json = new JSONObject(str);
            param = json.has("data") ? json.getJSONObject("data") : new JSONObject();
            if (json.has("sums")) {
                sums = json.get("sums");
            }
        } else {
            param = new JSONObject();
        }
        Map<String, Object> params = JsonHelper.toMap(param);
        String sql = this.call(name, params);
        sql = this.filterOutOrderBy(sql, sums);
        Session session = this.assignedSession == null ? this.sessionPool.getSession() : this.assignedSession;
        JSONArray array = SqlHelper.query(session, sql);
        return array.getJSONObject(0);
    }

    public JSONObject queryHqlTotal(String name, String str) throws Exception {
        JSONObject json;
        JSONObject param = str != null && !str.isEmpty() ? ((json = new JSONObject(str)).has("data") ? json.getJSONObject("data") : new JSONObject()) : new JSONObject();
        Map params = param.toMap();
        String sql = this.call(name, params);
        Session session = this.assignedSession == null ? this.sessionPool.getSession() : this.assignedSession;
        JSONArray array = SqlHelper.hqlQuery(session, sql);
        return array.getJSONObject(0);
    }

    public JSONArray query(String name, String str) throws Exception {
        return this.query(name, 0, 1000, str);
    }

    public static boolean deleteFile(String filePath) {
        File file = new File(filePath);
        if (file.isFile() && file.exists()) {
            boolean succeedDelete = file.delete();
            if (succeedDelete) {
                log.debug((Object)("\u5220\u9664" + filePath + "\u6210\u529f\uff01"));
            } else {
                log.debug((Object)("\u5220\u9664" + filePath + "\u5931\u8d25\uff01"));
            }
            return true;
        }
        log.debug((Object)("\u5220\u9664" + filePath + "\u5931\u8d25\uff01"));
        return false;
    }

    public JSONArray query(String name, JSONObject params) throws Exception {
        Map<String, Object> map = JsonHelper.toMap(params);
        return this.query(name, 1, 1000, map);
    }

    public JSONArray query(String name, JSONObject params, Integer pageSize) throws Exception {
        Map<String, Object> map = JsonHelper.toMap(params);
        return pageSize <= 0 ? this.query(name, 1, 9999999, map) : this.query(name, 1, (int)pageSize, map);
    }

    public JSONArray query(String name, Map<String, Object> params) throws Exception {
        return this.query(name, 1, 1000, params);
    }

    public JSONArray query(String name, Map<String, Object> params, Integer pageSize) throws Exception {
        return pageSize <= 0 ? this.query(name, 1, 9999999, params) : this.query(name, 1, (int)pageSize, params);
    }

    public JSONArray query(String name, int pageNo, int pageSize, String str) throws Exception {
        JSONObject param;
        if (pageNo <= 0) {
            pageNo = 1;
        }
        if (pageSize < 1) {
            pageSize = 9999999;
        }
        if (str != null && !str.isEmpty()) {
            param = new JSONObject(str);
            param = param.getJSONObject("data");
        } else {
            param = new JSONObject();
        }
        Map params = param.toMap();
        return this.query(name, pageNo, pageSize, params);
    }

    public JSONArray query(String name, int pageNo, int pageSize, Map<String, Object> params) throws Exception {
        String sql = this.call(name, params);
        Session session = this.assignedSession == null ? this.sessionPool.getSession() : this.assignedSession;
        JSONArray array = SqlHelper.query(session, sql, pageNo - 1, pageSize);
        log.info((Object)("SQL[" + name + "] Result: \n" + array.toString()));
        return array;
    }

    public String getSQL(String name, JSONObject params) {
        Map<String, Object> map = JsonHelper.toMap(params);
        return this.call(name, map);
    }

    @Deprecated
    public JSONArray query(String sql) throws Exception {
        return this.querySQL(sql);
    }

    public JSONArray querySQL(String sql) throws Exception {
        return this.querySQL(sql, 1, 9999999, false);
    }

    public JSONArray querySQL(String sql, boolean isNoLog) throws Exception {
        return this.querySQL(sql, 1, 9999999, isNoLog);
    }

    public JSONArray querySQL(String sql, Integer pageSize) throws Exception {
        return this.querySQL(sql, pageSize, false);
    }

    public JSONArray querySQL(String sql, Integer pageSize, boolean isNoLog) throws Exception {
        return pageSize <= 0 ? this.querySQL(sql, 1, 9999999, isNoLog) : this.querySQL(sql, 1, pageSize, isNoLog);
    }

    public JSONArray querySQL(String sql, int pageNo, int pageSize) throws Exception {
        return this.querySQL(sql, pageNo, pageSize, false);
    }

    public JSONArray querySQL(String sql, int pageNo, int pageSize, boolean isNoLog) throws Exception {
        if (pageNo <= 0) {
            pageNo = 1;
        }
        if (pageSize < 1) {
            pageSize = 9999999;
        }
        Session session = this.assignedSession == null ? this.sessionPool.getSession() : this.assignedSession;
        JSONArray array = SqlHelper.query(session, sql, pageNo - 1, pageSize, isNoLog);
        if (!isNoLog) {
            log.info((Object)("SQL Result: \n" + array.toString()));
        }
        return array;
    }

    public void run(String sql) throws NullPointerException {
        Session session = this.assignedSession == null ? this.sessionPool.getSession() : this.assignedSession;
        SqlHelper.bulkSQLUpdate(session, sql);
    }

    public void run(String sql, Object ... params) {
        String useSql = String.format(sql.replace("{}", "%s"), params);
        Session session = this.assignedSession == null ? this.sessionPool.getSession() : this.assignedSession;
        SqlHelper.bulkSQLUpdate(session, useSql);
    }

    public void runDeleteSQL(Session session, String sql) {
        EntityServer entityServer = new EntityServer();
        String[] sqlStr = sql.trim().split("\\s+");
        List<String> childStr = entityServer.getChildName(sqlStr[2]);
        for (String str : childStr) {
            String sqlRes = sql.replaceFirst(sqlStr[2], str);
            this.doCascade(session, sqlRes);
            SqlHelper.bulkSQLUpdate(session, sqlRes);
        }
        this.doCascade(session, sql);
        SqlHelper.bulkSQLUpdate(session, sql);
    }

    public void runUpdateSQL(Session session, String sql) {
        EntityServer entityServer = new EntityServer();
        String[] sqlStr = sql.trim().split("\\s+");
        List<String> childStr = entityServer.getChildName(sqlStr[1]);
        for (String str : childStr) {
            String sqlRes = sql.replaceFirst(sqlStr[1], str);
            SqlHelper.bulkSQLUpdate(session, sqlRes);
        }
        SqlHelper.bulkSQLUpdate(session, sql);
    }

    public ResultSet runQuerySQL(String sql) {
        Session session = this.assignedSession == null ? this.sessionPool.getSession() : this.assignedSession;
        return (ResultSet)session.doReturningWork(connection -> {
            PreparedStatement preparedStatement = connection.prepareStatement(sql);
            return preparedStatement.executeQuery();
        });
    }

    private static List<Map<String, Object>> saveList(JSONArray array) throws Exception {
        ArrayList<Map<String, Object>> set = new ArrayList<Map<String, Object>>();
        for (int i = 0; i < array.length(); ++i) {
            JSONObject obj = (JSONObject)array.get(i);
            Map<String, Object> map = SqlServer.toMap(obj);
            set.add(map);
        }
        return set;
    }

    private static Map<String, Object> toMap(JSONObject object) {
        return object.toMap();
    }

    public JSONArray query(String name, String str, Integer pageSize) throws Exception {
        return pageSize <= 0 ? this.query(name, 1, 9999999, str) : this.query(name, 1, (int)pageSize, str);
    }

    public void doCascade(Session session, String sql) {
        sql = sql.trim();
        HashMap<String, HashMap<String, Object>> metaMap = EntityServer.metaMap;
        String[] sqlStr = sql.split("\\s+");
        String idnum = (String)metaMap.get(sqlStr[2]).get("idColName");
        String resql = sql.replaceFirst(sqlStr[0], "SELECT " + idnum);
        try {
            JSONArray value = this.querySQL(resql);
            if (value.length() > 0) {
                for (int j = 0; j < value.length(); ++j) {
                    JSONObject job = value.getJSONObject(j);
                    String res = job.get(idnum).toString();
                    this.cascadeDelete(session, sqlStr[2], res);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public int runSQL(String sql) {
        Session session = this.assignedSession == null ? this.sessionPool.getSession() : this.assignedSession;
        return SqlHelper.bulkSQLUpdate(session, sql);
    }

    public int runSQL(String sql, Object ... params) {
        String useSql = String.format(sql.replace("{}", "%s"), params);
        Session session = this.assignedSession == null ? this.sessionPool.getSession() : this.assignedSession;
        return SqlHelper.bulkSQLUpdate(session, useSql);
    }

    public String call(String sqlName, JSONObject json) throws Exception {
        Map<String, Object> param = JsonHelper.toMap(json);
        return this.call(sqlName, param);
    }

    public String call(String sqlName, Map<String, Object> params) {
        String sql;
        String path = SqlMapper.getSql(sqlName);
        if (path == null) {
            throw new RuntimeException("sql\u8bed\u53e5\u672a\u6ce8\u518c\uff01" + sqlName);
        }
        try {
            sql = (String)ResourceHelper.getString(ResourceType.SQL, sqlName, path);
            if (sql.contains("${")) {
                sql = sql.replace("${", "{");
            }
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException(path + ".\u6587\u4ef6\u65e0\u914d\u7f6e");
        }
        catch (IOException io) {
            throw new RuntimeException(io);
        }
        params.put("sql", this);
        params.put("entity", this.entityServer);
        sql = ExpressionHelper.run(sql, params).toString();
        return sql;
    }

    public void cascadeDelete(Session session, String tableName, String idValue) {
        HashMap<String, HashMap<String, Object>> metaMap = EntityServer.metaMap;
        String idNum = (String)metaMap.get(tableName).get("idColName");
        this.deleteFileDB(tableName, idValue);
        if (metaMap.containsKey(tableName)) {
            ArrayList cascadeTable = new ArrayList();
            HashMap cascadMap = (HashMap)metaMap.get(tableName).get("onetoone");
            cascadMap.putAll((HashMap)metaMap.get(tableName).get("onetomany"));
            Set keys = cascadMap.keySet();
            Iterator iter = keys.iterator();
            int i = 0;
            while (iter.hasNext()) {
                cascadeTable.add(iter.next());
                ++i;
            }
            for (String str : cascadeTable) {
                Pair pair = (Pair)cascadMap.get(str);
                String tableString = (String)metaMap.get(pair.col).get("tableName");
                String tableId = (String)metaMap.get(pair.col).get("idColName");
                String selSql = metaMap.get(pair.col).get("idType") == "STRING" ? "SELECT " + tableId + " FROM " + tableString + " WHERE " + pair.type + "='" + idValue + "'" : "SELECT " + tableId + " FROM " + tableString + " WHERE " + pair.type + "=" + idValue;
                try {
                    JSONArray array = this.querySQL(selSql);
                    if (array.length() <= 0) continue;
                    for (int j = 0; j < array.length(); ++j) {
                        JSONObject job = array.getJSONObject(j);
                        String res = job.get(tableId).toString();
                        String sqlStr = job.get(tableId) instanceof String ? "DELETE FROM " + pair.col + " WHERE " + tableId + "='" + res + "'" : "DELETE FROM " + pair.col + " WHERE " + tableId + "=" + res;
                        this.runDeleteSQL(session, sqlStr);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        String delSql = metaMap.get(tableName).get("idType") == "STRING" ? "DELETE FROM " + tableName + " WHERE " + idNum + "= '" + idValue + "'" : "DELETE FROM " + tableName + " WHERE " + idNum + "=" + idValue;
        SqlHelper.bulkSQLUpdate(session, delSql);
    }

    public void deleteFileDB(String tableName, String idValue) {
        HashMap<String, HashMap<String, Object>> metaMap = EntityServer.metaMap;
        Map columns = (Map)metaMap.get(tableName).get("columns");
        if (columns != null && columns.containsKey("path")) {
            String idNum = (String)metaMap.get(tableName).get("idColName");
            String selSql = "SELECT path FROM " + tableName + " WHERE " + idNum + "=" + idValue;
            try {
                JSONArray array = this.querySQL(selSql);
                if (array.length() > 0) {
                    for (int i = 0; i < array.length(); ++i) {
                        JSONObject job = array.getJSONObject(i);
                        String filePath = job.get("path").toString();
                        if (filePath == null) continue;
                        Boolean bl = SqlServer.deleteFile(filePath);
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public JSONArray hqlQuery(String name, int pageNo, int pageSize, String str) throws Exception {
        if (pageNo <= 0) {
            pageNo = 1;
        }
        if (pageSize < 1 || pageSize > 1000) {
            pageSize = 1000;
        }
        JSONObject param = null;
        if (str != null && !str.isEmpty()) {
            param = new JSONObject(str);
            param = param.getJSONObject("data");
        } else {
            param = new JSONObject();
        }
        Map<String, Object> params = JsonHelper.toMap(param);
        return this.hqlQuery(name, pageNo, pageSize, params);
    }

    public JSONArray hqlQueryAll(String name, int pageNo, int pageSize, String str) throws Exception {
        if (pageNo <= 0) {
            pageNo = 1;
        }
        if (pageSize < 1) {
            pageSize = 1000;
        }
        JSONObject param = null;
        if (str != null && !str.isEmpty()) {
            param = new JSONObject(str);
            param = param.getJSONObject("data");
        } else {
            param = new JSONObject();
        }
        Map<String, Object> params = JsonHelper.toMap(param);
        return this.hqlQuery(name, pageNo, pageSize, params);
    }

    public JSONArray hqlQuery(String name, int pageNo, int pageSize, Map<String, Object> params) throws Exception {
        String sql = this.call(name, params);
        Session session = this.assignedSession == null ? this.sessionPool.getSession() : this.assignedSession;
        JSONArray array = SqlHelper.hqlQuery(session, sql, pageNo - 1, pageSize);
        log.info((Object)("SQL[" + name + "] Result: \n" + array.toString()));
        return array;
    }

    public JSONArray hqlQuery(String name, JSONObject params) throws Exception {
        Map<String, Object> map = JsonHelper.toMap(params);
        String sql = this.call(name, map);
        Session session = this.assignedSession == null ? this.sessionPool.getSession() : this.assignedSession;
        return SqlHelper.hqlQuery(session, sql);
    }

    public JSONArray hqlQuery(String hql) throws Exception {
        Session session = this.assignedSession == null ? this.sessionPool.getSession() : this.assignedSession;
        return SqlHelper.hqlQuery(session, hql);
    }

    public String filterOutOrderBy(String source, Object sums) throws Exception {
        int idx = source.toLowerCase().lastIndexOf("order by");
        if (idx == -1) {
            idx = source.length() - 1;
        }
        StringBuilder sql = new StringBuilder("select ");
        if (sums != null) {
            if (sums instanceof JSONArray) {
                JSONArray arraySums = (JSONArray)sums;
                for (int i = 0; i < arraySums.length(); ++i) {
                    String name = (String)arraySums.get(i);
                    sql.append("sum(").append(name).append(") ").append(name).append(", ");
                }
            } else if (sums instanceof JSONObject) {
                JSONObject objSums = (JSONObject)sums;
                Iterator keys = objSums.keys();
                while (keys.hasNext()) {
                    String name = (String)keys.next();
                    String value = objSums.getString(name);
                    sql.append("sum(").append(value).append(") ").append(name).append(", ");
                }
            }
        }
        if (idx != -1) {
            sql.append("count(*) n, 1 placeholder from ( ").append(source, 0, idx).append(") t_");
        }
        return sql.toString();
    }

    public JSONObject action(JSONObject json) {
        JSONObject result = new JSONObject();
        try {
            if (json.has("alias")) {
                JSONArray array;
                JSONObject data = new JSONObject();
                if (json.has("count")) {
                    String sumJSON = this.call(json.getString("alias"), json);
                    result.put("code", 200);
                    data.put("sum", (Object)sumJSON);
                    result.put("data", (Object)data);
                }
                if (json.has("pageNo")) {
                    Map<String, Object> params = SqlServer.toMap(json.getJSONObject("criteria"));
                    array = this.hqlQuery(json.getString("alias"), json.getInt("pageNo"), json.getInt("pageSize"), params);
                    result.put("code", 200);
                    data.put("rows", (Object)array);
                    result.put("data", (Object)data);
                    log.debug((Object)("\u5f97\u5230\u6570\u636e" + data));
                } else {
                    Map<String, Object> params = SqlServer.toMap(json.getJSONObject("criteria"));
                    array = this.hqlQuery(json.getString("alias"), -1, -1, params);
                    result.put("code", 200);
                    data.put("rows", (Object)array);
                    result.put("data", (Object)data);
                    log.debug((Object)("\u5f97\u5230\u6570\u636e" + data));
                }
            } else if (json.has("cmd")) {
                this.run(json.getString("sql"));
                result.put("code", 200);
                result.put("data", (Object)"");
            } else if (json.has("cmd2")) {
                this.run(json.getString("sql"), "del");
                result.put("code", 200);
                result.put("data", (Object)"");
            } else {
                JSONArray rows = this.querySQL(json.getString("sql"));
                result.put("code", 200);
                result.put("data", (Object)rows);
            }
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException("\u6267\u884c\u9519\u8bef\uff01", e);
        }
        return result;
    }

    public void openStandardTransformerSupport() {
        SQLRuntimeSupport.openStandardTransformer();
    }

    public void closeStandardTransformerSupport() {
        SQLRuntimeSupport.closeStandardTransformer();
    }
}

