/*
 * Decompiled with CFR 0.152.
 */
package com.aote.queryparams.enums;

import com.aote.config.SaleVersionEnum;
import com.aote.config.SystemConfig;
import java.util.stream.Stream;

public enum CompatColumnNameEnum {
    USER_ID("$userid", "f_user_id", "f_userfiles_id", "f_userfiles_id"),
    IOT_HAND_PLAN_NAME("$iotHandPlanName", "t_handplan", "t_handplan", "t_web_handplan");

    private final String name;
    private final String v2Value;
    private final String v3Value;
    private final String v4Value;

    private CompatColumnNameEnum(String name, String v2Value, String v3Value, String v4Value) {
        this.name = name;
        this.v2Value = v2Value;
        this.v3Value = v3Value;
        this.v4Value = v4Value;
    }

    public static CompatColumnNameEnum toType(String name) {
        return Stream.of(CompatColumnNameEnum.values()).filter(p -> p.name.equals(name)).findAny().orElse(null);
    }

    public static boolean is(String value) {
        return CompatColumnNameEnum.toType(value) != null;
    }

    public String getName() {
        return this.name;
    }

    public String getValue() {
        SaleVersionEnum saleVersionEnum = SystemConfig.System.saleVersion();
        if (saleVersionEnum == SaleVersionEnum.V4) {
            return this.v4Value;
        }
        if (saleVersionEnum == SaleVersionEnum.Vue_V3) {
            return this.v3Value;
        }
        return this.v2Value;
    }
}

