package com.aote.columns;

import com.aote.exception.FileNotFoundException;
import com.aote.queryparams.QueryParamsMapper;
import com.aote.util.ResourceHelper;
import com.aote.util.ResourceType;
import org.apache.log4j.Logger;
import org.json.JSONArray;
import org.json.JSONObject;
import org.springframework.stereotype.Component;

import java.io.IOException;

@Component
public class ColumnsServer {
    private static final Logger LOGGER = Logger.getLogger(ColumnsServer.class);

    /**
     * 获取前端用于生成表格展示列和表单项的集合
     *
     * @param name columns文件名
     * @return 文件内容
     */
    public static JSONObject getValue(String name) throws Exception {
        String path = QueryParamsMapper.getQueryParams(name);
        if (path == null) {
            throw new RuntimeException("查询参数文件未找到: " + name);
        }
        JSONObject queryParamsMap;
        try {
            queryParamsMap = (JSONObject) ResourceHelper.getString(ResourceType.QUERY_PARAMS,name,path);
        } catch (FileNotFoundException e) {
            throw new RuntimeException(path + ".文件无配置");
        } catch (IOException io) {
            throw new RuntimeException(io);
        }
        JSONArray columnJson = queryParamsMap.getJSONArray("columnJson");
        JSONArray formJson = queryParamsMap.getJSONArray("formJson");
        JSONObject result = new JSONObject();
        result.put("columnJson",columnJson);
        result.put("formJson",formJson);
        return result;
    }
}
