/*
 * Decompiled with CFR 0.152.
 */
package com.aote.logic;

import com.af.expression.Delegate;
import com.aote.entity.EntityServer;
import com.aote.exception.ExceptionLogManage;
import com.aote.exception.FileNotFoundException;
import com.aote.logic.LogicMapper;
import com.aote.logic.PluginMapper;
import com.aote.redis.RedisUtil;
import com.aote.rs.mapper.WebException;
import com.aote.sql.SqlMapper;
import com.aote.sql.SqlServer;
import com.aote.transaction.SessionPool;
import com.aote.util.ExceptionHelper;
import com.aote.util.ExpressionHelper;
import com.aote.util.ResourceHelper;
import com.aote.util.ResourceType;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.PostConstruct;
import org.apache.log4j.Logger;
import org.hibernate.SessionFactory;
import org.json.JSONArray;
import org.json.JSONObject;
import org.json.JSONTokener;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
@Transactional
public class LogicServer {
    static Logger log = Logger.getLogger(LogicServer.class);
    @Autowired
    private EntityServer entityServer;
    @Autowired
    private SqlServer sqlServer;
    @Autowired
    private SessionPool sessionPool;
    @Autowired
    private SessionFactory sessionFactory;
    @Autowired
    private ExceptionLogManage exceptionLogManage;

    public Object run(String name, String str) {
        JSONObject param = null;
        if ((str = str.trim()).startsWith("<") && str.endsWith(">")) {
            param = new JSONObject();
            param.put("xml", (Object)str);
        } else {
            Object json = new JSONTokener(str).nextValue();
            if (json instanceof JSONObject) {
                Object dataParam;
                param = new JSONObject(str);
                if (!param.isNull("data") && (dataParam = param.get("data")) instanceof JSONObject) {
                    param = (JSONObject)dataParam;
                    param.put("standardData", (Object)new JSONObject(str).toString());
                }
            } else if (json instanceof JSONArray) {
                param = new JSONObject();
                param.put("arr", (Object)new JSONArray(str));
            }
        }
        return this.run(name, param);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object run(String name, JSONObject param) {
        Object result;
        Delegate delegate;
        String message = "\u7ef4\u62a4\u4fe1\u606f:\u5f00\u59cb\u6267\u884cLogic[" + name + "]\uff0c\u53c2\u6570\uff1a" + param;
        log.debug((Object)message);
        String path = LogicMapper.getLogic(name);
        if (path == null) {
            throw new RuntimeException("\u4e1a\u52a1\u903b\u8f91\u672a\u627e\u5230: " + name);
        }
        try {
            delegate = (Delegate)ResourceHelper.getString(ResourceType.LOGIC, name, path);
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException(path + ".\u6587\u4ef6\u65e0\u914d\u7f6e");
        }
        catch (IOException io) {
            throw new RuntimeException(io);
        }
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("data", param);
        params.put("log", log);
        params.put("entity", this.entityServer);
        params.put("sql", this.sqlServer);
        params.put("session", this.sessionPool.getSession());
        params.put("redis", RedisUtil.getInstance());
        params.put("logic", this);
        Map<String, Object> plugins = PluginMapper.getPlugins();
        params.putAll(plugins);
        long begin = System.currentTimeMillis();
        try {
            result = ExpressionHelper.run(delegate, params);
        }
        finally {
            long end = System.currentTimeMillis();
            long time = end - begin;
            String EngMessage = "\u7ef4\u62a4\u4fe1\u606f:\u6267\u884cLogic[" + name + "]\u8017\u65f6:" + time;
            if (time >= 5000L) {
                log.error((Object)EngMessage);
            } else if (time >= 500L) {
                log.warn((Object)EngMessage);
            } else {
                log.debug((Object)EngMessage);
            }
        }
        return result;
    }

    public String runMain(String logicName, String values) {
        try {
            Object result = this.run(logicName, values);
            if (result == null) {
                return "";
            }
            if (result instanceof Map) {
                JSONObject json = new JSONObject((Map)result);
                return json.toString();
            }
            if (result instanceof JSONObject) {
                JSONObject json = (JSONObject)result;
                return json.toString();
            }
            return result.toString();
        }
        catch (Exception ex) {
            String stack = ExceptionLogManage.getErrorInfo(ExceptionHelper.stackToString(ex), 1);
            log.error((Object)stack);
            String path = LogicMapper.getLogic(logicName);
            if (path == null) {
                path = logicName;
            }
            this.exceptionLogManage.writeError(ex, path, "/rs/logic/" + logicName, values);
            WebException wex = this.getWebException(ex);
            if (wex != null) {
                throw wex;
            }
            throw ex;
        }
    }

    @Async(value="AsyncLogicGet")
    public void runAsync(String logicName, String values) {
        this.runMain(logicName, values);
    }

    private WebException getWebException(Exception ex) {
        for (Throwable cause = ex; cause != null; cause = cause.getCause()) {
            if (!(cause instanceof WebException)) continue;
            return (WebException)cause;
        }
        return null;
    }

    @PostConstruct
    public void redisCacheLogic() throws Exception {
        if (ResourceHelper.class.getResourceAsStream("/config.json") == null) {
            log.debug((Object)"\u65e0config.json\u6587\u4ef6\uff0c\u4e0d\u8fdb\u884credis\u7f13\u5b58");
            return;
        }
        String strConfig = ResourceHelper.getString("config.json");
        JSONObject jsonObject = new JSONObject(strConfig);
        if (!jsonObject.has("logicRegister")) {
            log.debug((Object)"config.json\u4e2d\u65e0\u6a21\u5757\u955c\u50cf\uff0c\u4e0d\u8fdb\u884credis\u7f13\u5b58");
            return;
        }
        JSONObject logicJsonObject = jsonObject.getJSONObject("logicRegister");
        String url = logicJsonObject.getString("url");
        if (url == null) {
            log.debug((Object)"config.json\u4e2d\u65e0url\uff0c\u4e0d\u8fdb\u884credis\u7f13\u5b58");
            return;
        }
        RedisUtil redisUtil = RedisUtil.getInstance();
        Map<String, Map<String, String>> map = LogicMapper.getMap();
        if (map != null) {
            for (String key : map.keySet()) {
                redisUtil.set(key, url);
                log.debug((Object)("logic\u52a0\u5165redis\u7f13\u5b58\uff0ckey=" + key + ", value=" + url));
            }
        }
        if ((map = SqlMapper.getMap()) != null) {
            for (String key : map.keySet()) {
                redisUtil.set(key, url);
                log.debug((Object)("sql\u52a0\u5165redis\u7f13\u5b58\uff0ckey=" + key + ", value=" + url));
            }
        }
        Map entities = this.sessionFactory.getAllClassMetadata();
        for (String key : entities.keySet()) {
            redisUtil.set(key, url);
            log.debug((Object)("entity\u52a0\u5165redis\u7f13\u5b58\uff0ckey=" + key + ", value=" + url));
        }
    }
}

