/*
 * Decompiled with CFR 0.152.
 */
package com.aote.redis;

import com.aote.config.SystemConfig;
import com.aote.redis.RedisService;
import com.aote.rs.mapper.WebException;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.log4j.Logger;
import org.json.JSONObject;
import org.redisson.Redisson;
import org.redisson.api.RBucket;
import org.redisson.api.RLock;
import org.redisson.api.RMap;
import org.redisson.api.RedissonClient;
import org.redisson.config.Config;
import org.redisson.config.SingleServerConfig;

public class RedisUtil
implements RedisService {
    private static volatile RedisUtil redisUtil;
    private static final RedissonClient REDISSON_CLIENT;
    private static final Logger log;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static RedisUtil getInstance() {
        if (redisUtil != null) return redisUtil;
        Class<RedisUtil> clazz = RedisUtil.class;
        synchronized (RedisUtil.class) {
            if (redisUtil != null || REDISSON_CLIENT == null) return redisUtil;
            redisUtil = new RedisUtil();
            // ** MonitorExit[var0] (shouldn't be in output)
            return redisUtil;
        }
    }

    private RedisUtil() {
    }

    @Override
    public void set(String key, Object value) {
        this.set(key, value, -1L);
    }

    @Override
    public void set(String key, Object value, long timeoutSec) {
        RBucket rBucket = REDISSON_CLIENT.getBucket(key);
        if (timeoutSec > 0L) {
            rBucket.set((Object)String.valueOf(value), timeoutSec, TimeUnit.SECONDS);
        } else {
            rBucket.set((Object)String.valueOf(value));
        }
    }

    @Override
    public void setHash(String hashKey, JSONObject value) {
        this.setHash(hashKey, value.toMap());
    }

    @Override
    public void setHash(String hashKey, Map<String, Object> value) {
        this.setHash(hashKey, value, -1L);
    }

    @Override
    public void setHash(String hashKey, Map<String, Object> value, long timeoutSec) {
        RMap rMap = REDISSON_CLIENT.getMap(hashKey);
        rMap.putAll(value);
        if (timeoutSec > 0L) {
            rMap.expire(timeoutSec, TimeUnit.SECONDS);
        }
    }

    @Override
    public JSONObject getHash(String hashKey) {
        return new JSONObject((Map)REDISSON_CLIENT.getMap(hashKey));
    }

    @Override
    public Object getHash(String hashKey, String key) {
        return REDISSON_CLIENT.getMap(hashKey).get((Object)key);
    }

    @Override
    public void setHashKey(String hashKey, String key, Object value) {
        REDISSON_CLIENT.getMap(hashKey).put((Object)key, value);
    }

    @Override
    public void deleteHashKey(String hashKey, String key) {
        REDISSON_CLIENT.getMap(hashKey).remove((Object)key);
    }

    @Override
    public Boolean hasHashKey(String hashKey, String key) {
        return REDISSON_CLIENT.getMap(hashKey).containsKey((Object)key);
    }

    @Override
    public void lock(String key, Runnable runnable) {
        this.lock(key, 10, 20, runnable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void lock(String key, Integer waitTime, Integer leaseTime, Runnable runnable) {
        block7: {
            RLock lock = REDISSON_CLIENT.getLock("LOCK-" + key);
            try {
                boolean isLock = lock.tryLock((long)waitTime.intValue(), (long)leaseTime.intValue(), TimeUnit.SECONDS);
                if (isLock) {
                    runnable.success();
                    break block7;
                }
                throw new WebException(505, "\u4fee\u6539\u5931\u8d25\uff0c\u8be5\u6570\u636e\u53d7\u9501\u4fdd\u62a4\u4e2d\u3002");
            }
            catch (InterruptedException e) {
                log.error((Object)("\u5206\u5e03\u5f0f\u9501" + lock.getName() + "\u83b7\u53d6\u5931\u8d25"));
                e.printStackTrace();
            }
            finally {
                if (lock.isHeldByCurrentThread()) {
                    lock.unlock();
                }
            }
        }
    }

    @Override
    public Object get(String key) {
        return REDISSON_CLIENT.getBucket(key).get();
    }

    @Override
    public void delete(String key) {
        REDISSON_CLIENT.getBucket(key).delete();
    }

    @Override
    public void deleteList(Iterable<Object> keys) {
        keys.forEach(item -> this.delete(String.valueOf(item)));
    }

    @Override
    public void deleteList(JSONObject keys) {
        this.deleteList(new ArrayList<Object>(keys.keySet()));
    }

    static {
        log = Logger.getLogger(RedisUtil.class);
        if (SystemConfig.Redis.hasHostName()) {
            Config config = new Config();
            SingleServerConfig singleServerConfig = config.useSingleServer();
            singleServerConfig.setAddress("redis://" + SystemConfig.Redis.getHostName());
            if (SystemConfig.Redis.hasPassword()) {
                singleServerConfig.setPassword(SystemConfig.Redis.getPassword());
            }
            REDISSON_CLIENT = Redisson.create((Config)config);
            log.info((Object)"***redis\u5b9e\u4f8b\u5df2\u52a0\u8f7d\u5b8c\u6210***");
        } else {
            REDISSON_CLIENT = null;
            log.warn((Object)"***redis\u5b9e\u4f8b\u672a\u914d\u7f6e***");
        }
    }

    @FunctionalInterface
    public static interface Runnable {
        public void success();
    }
}

