/*
 * Decompiled with CFR 0.152.
 */
package com.aote.queryparams;

import com.aote.queryparams.QueryParamsServer;
import com.aote.redis.RedisUtil;
import com.aote.rs.SqlService;
import javax.annotation.PostConstruct;
import org.apache.log4j.Logger;
import org.json.JSONArray;
import org.json.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class QueryParamsMapper {
    private static final Logger LOGGER = Logger.getLogger(QueryParamsMapper.class);
    public static final String QUERY_PARAMS_IS_LOADED_KEY = "QUERY_PARAMS_IS_LOADED";
    public static final String NO_LOAD_FLAG = "0";
    public static final String LOADED_FLOG = "1";
    public static final String QUERY_PARAMS_PREFIX = "QP_";
    private static final String QUERY_SQL = "SELECT * FROM T_QUERY_PARAMS WHERE F_CONTENT IS NOT NULL";
    @Autowired
    private SqlService sqlService;

    @PostConstruct
    public void load() {
        RedisUtil redisUtil = RedisUtil.getInstance();
        if (redisUtil != null) {
            redisUtil.lock(QUERY_PARAMS_IS_LOADED_KEY, () -> {
                Object isLoaded = redisUtil.get(QUERY_PARAMS_IS_LOADED_KEY);
                if (isLoaded == null || NO_LOAD_FLAG.equals(isLoaded)) {
                    JSONArray result = null;
                    try {
                        result = new JSONArray(this.sqlService.txQuery(QUERY_SQL));
                    }
                    catch (Exception e) {
                        LOGGER.warn((Object)"\u67e5\u8be2\u914d\u7f6e\u8868(t_query_params)\u67e5\u8be2\u5931\u8d25\uff0c\u4e0d\u518d\u52a0\u8f7d\u67e5\u8be2\u914d\u7f6e");
                    }
                    if (result != null) {
                        for (Object o : result) {
                            JSONObject item = (JSONObject)o;
                            if (!item.has("f_content")) continue;
                            JSONObject compileSource = QueryParamsServer.getQueryParamsInfo(item.getString("f_content"));
                            redisUtil.set(QUERY_PARAMS_PREFIX + item.getString("f_name"), compileSource);
                        }
                        redisUtil.set(QUERY_PARAMS_IS_LOADED_KEY, LOADED_FLOG);
                        LOGGER.debug((Object)"\u67e5\u8be2\u914d\u7f6e\u9884\u52a0\u8f7d\u5b8c\u6210");
                    }
                } else {
                    LOGGER.debug((Object)"\u8df3\u8fc7\u52a0\u8f7d\u67e5\u8be2\u914d\u7f6e\u8868");
                }
            });
        }
    }
}

