/*
 * Decompiled with CFR 0.152.
 */
package com.aote.module;

import com.af.expression.Program;
import com.aote.exception.FileNotFoundException;
import com.aote.logic.LogicMapper;
import com.aote.module.ModuleMapper;
import com.aote.sql.SqlMapper;
import com.aote.util.ResourceHelper;
import com.aote.util.ResourceType;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.PostConstruct;
import org.apache.log4j.Logger;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;
import org.springframework.stereotype.Component;

@Component
public class ResCheck {
    private static final Logger LOGGER = Logger.getLogger(ResCheck.class);
    private static final List<String> ERROR_ARRAY = new ArrayList<String>();

    @PostConstruct
    public void checkAll() {
        Map<String, Map<String, String>> map = ModuleMapper.getMap();
        int GrammarErrorNums = 0;
        int GrammarErrorSQLNums = 0;
        for (String module : map.keySet()) {
            String modulePath = map.get(module).get("path");
            String logicUrl = modulePath == null ? module + "/logic.xml" : modulePath + "/" + module + "/logic.xml";
            String sqlUrl = modulePath == null ? module + "/sql.xml" : modulePath + "/" + module + "/sql.xml";
            GrammarErrorNums += this.checkLogicGrammar(module, logicUrl);
            GrammarErrorSQLNums += this.checkSqlResource(module, sqlUrl);
        }
        boolean throwError = false;
        String msg = "";
        if (GrammarErrorNums > 0) {
            throwError = true;
            msg = "Logic\u5f3a\u5236\u68c0\u67e5\u672a\u901a\u8fc7\uff0c\u5171\u6709" + GrammarErrorNums + "\u9879\u9519\u8bef\uff0c\u5982\u679c\u60a8\u5728\u67e5\u770btomcat\u65e5\u5fd7\uff0c\u8bf7\u8f6c\u5230\u5e94\u7528\u65e5\u5fd7\u67e5\u770b\u9519\u8bef\u8be6\u60c5";
        }
        if (GrammarErrorSQLNums > 0) {
            throwError = true;
            if (!msg.equals("")) {
                msg = msg + "\n";
            }
            msg = msg + "SQL\u5f3a\u5236\u68c0\u67e5\u672a\u901a\u8fc7\uff0c\u5171\u6709" + GrammarErrorSQLNums + "\u9879\u9519\u8bef\uff0c\u5982\u679c\u60a8\u5728\u67e5\u770btomcat\u65e5\u5fd7\uff0c\u8bf7\u8f6c\u5230\u5e94\u7528\u65e5\u5fd7\u67e5\u770b\u9519\u8bef\u8be6\u60c5";
        }
        if (throwError) {
            StringBuilder errorWelcome = new StringBuilder("\n/***\n * _ooOoo_\n * o8888888o\n * 88\" . \"88\n * (| -_- |)\n *  O\\ = /O\n * ___/`---'\\____\n * .   ' \\\\| |// `.\n * / \\\\||| : |||// \\\n * / _||||| -:- |||||- \\\n * | | \\\\\\ - /// | |\n * | \\_| ''\\---/'' | |\n * \\ .-\\__ `-` ___/-. /\n * ___`. .' /--.--\\ `. . __\n * .\"\" '< `.___\\_<|>_/___.' >'\"\".\n * | | : `- \\`.;`\\ _ /`;.`/ - ` : | |\n * \\ \\ `-. \\_ __\\ /__ _/ .-` / /\n * ======`-.____`-.___\\_____/___.-`____.-'======\n * `=---='\n * .............................................\n * \u4f5b\u66f0\uff1abug\u6cdb\u6ee5\uff0c\u6211\u5df2\u762b\u75ea\uff01\n * " + msg + "\n");
            for (int i = 0; i < ERROR_ARRAY.size(); ++i) {
                errorWelcome.append(" * ").append(i).append(". ").append(ERROR_ARRAY.get(i)).append("\n");
            }
            errorWelcome.append(" */");
            LOGGER.error((Object)errorWelcome);
            throw new RuntimeException(msg);
        }
        String successWelcome = "\n/***\n *                    _ooOoo_\n *                   o8888888o\n *                   88\" . \"88\n *                   (| -_- |)\n *                    O\\ = /O\n *                ____/`---'\\____\n *              .   ' \\\\| |// `.\n *               / \\\\||| : |||// \\\n *             / _||||| -:- |||||- \\\n *               | | \\\\\\ - /// | |\n *             | \\_| ''\\---/'' | |\n *              \\ .-\\__ `-` ___/-. /\n *           ___`. .' /--.--\\ `. . __\n *        .\"\" '< `.___\\_<|>_/___.' >'\"\".\n *       | | : `- \\`.;`\\ _ /`;.`/ - ` : | |\n *         \\ \\ `-. \\_ __\\ /__ _/ .-` / /\n * ======`-.____`-.___\\_____/___.-`____.-'======\n *                    `=---='\n *\n * .............................................\n *          \u4f5b\u7956\u4fdd\u4f51             \u6c38\u65e0BUG\n */";
        LOGGER.info((Object)successWelcome);
    }

    private int checkSqlResource(String module, String sqlUrl) {
        InputStream input = LogicMapper.class.getClassLoader().getResourceAsStream(sqlUrl);
        int errorNums = 0;
        if (input != null) {
            SAXReader reader = new SAXReader();
            Document document = null;
            try {
                document = reader.read(input);
            }
            catch (DocumentException e) {
                e.printStackTrace();
            }
            assert (document != null);
            Element root = document.getRootElement();
            List sqls = root.elements("sql");
            LOGGER.debug((Object)("\u68c0\u67e5\u3010" + module + "\u3011\u6a21\u5757\u4e0bSql\u8d44\u6e90\u6620\u5c04\uff0c\u5171" + sqls.size() + "\u4e2a..."));
            AtomicInteger i = new AtomicInteger(1);
            AtomicInteger success = new AtomicInteger(0);
            AtomicInteger error = new AtomicInteger(0);
            sqls.forEach(it -> {
                String index = "(" + i + "/" + sqls.size() + ")";
                String alias = it.attribute("alias").getValue();
                String path = SqlMapper.getSql(alias);
                if (path == null) {
                    ERROR_ARRAY.add("Sql\u3010" + alias + "\u3011\u672a\u914d\u7f6e" + index);
                    error.set(error.get() + 1);
                } else {
                    try {
                        ResourceHelper.getString(ResourceType.SQL, alias, path);
                        success.set(success.get() + 1);
                    }
                    catch (FileNotFoundException e) {
                        ERROR_ARRAY.add("Sql\u3010" + alias + "\u3011\u672a\u627e\u5230\u6587\u4ef6\uff1a" + path);
                        error.set(error.get() + 1);
                    }
                    catch (IOException io) {
                        ERROR_ARRAY.add("Sql\u3010" + alias + "\u3011IO\u5f02\u5e38\uff1a" + path);
                        error.set(error.get() + 1);
                    }
                }
                i.set(i.get() + 1);
            });
            LOGGER.debug((Object)("\u3010" + module + "\u3011\u6a21\u5757\u8bed\u6cd5\u68c0\u67e5\u5b8c\u6210\uff0c\u5171" + sqls.size() + "\u4e2a,\u6b63\u786e" + success.get() + "\u4e2a,\u9519\u8bef" + error.get() + "\u4e2a"));
            errorNums += error.get();
        }
        return errorNums;
    }

    private int checkLogicGrammar(String module, String logicUrl) {
        InputStream input = LogicMapper.class.getClassLoader().getResourceAsStream(logicUrl);
        int errorNums = 0;
        if (input != null) {
            SAXReader reader = new SAXReader();
            Document document = null;
            try {
                document = reader.read(input);
            }
            catch (DocumentException e) {
                e.printStackTrace();
            }
            assert (document != null);
            Element root = document.getRootElement();
            List logics = root.elements("logic");
            LOGGER.debug((Object)("\u68c0\u67e5\u3010" + module + "\u3011\u6a21\u5757\u4e0bLogic\u8bed\u6cd5\uff0c\u5171" + logics.size() + "\u4e2a..."));
            AtomicInteger i = new AtomicInteger(1);
            AtomicInteger success = new AtomicInteger(0);
            AtomicInteger error = new AtomicInteger(0);
            logics.forEach(it -> {
                String index = "(" + i + "/" + logics.size() + ")";
                String alias = it.attribute("alias").getValue();
                String path = LogicMapper.getLogic(alias);
                if (path == null) {
                    ERROR_ARRAY.add("Logic\u3010" + alias + "\u3011\u672a\u914d\u7f6e" + index);
                    error.set(error.get() + 1);
                } else {
                    try {
                        String source = (String)ResourceHelper.getString(ResourceType.LOGIC, alias, path);
                        Program prog = new Program(source);
                        try {
                            prog.parse();
                            success.set(success.get() + 1);
                        }
                        catch (RuntimeException e) {
                            String message = e.getMessage();
                            ERROR_ARRAY.add("Logic\u3010" + alias + "\u3011\u7f16\u8bd1\u9519\u8bef\uff1a" + message);
                            error.set(error.get() + 1);
                        }
                    }
                    catch (FileNotFoundException e) {
                        ERROR_ARRAY.add("Logic\u3010" + alias + "\u3011\u672a\u627e\u5230\u6587\u4ef6\uff1a" + path);
                        error.set(error.get() + 1);
                    }
                    catch (IOException io) {
                        ERROR_ARRAY.add("Logic\u3010" + alias + "\u3011IO\u5f02\u5e38\uff1a" + path);
                        error.set(error.get() + 1);
                    }
                }
                i.set(i.get() + 1);
            });
            LOGGER.debug((Object)("\u3010" + module + "\u3011\u6a21\u5757\u8bed\u6cd5\u68c0\u67e5\u5b8c\u6210\uff0c\u5171" + logics.size() + "\u4e2a,\u6b63\u786e" + success.get() + "\u4e2a,\u9519\u8bef" + error.get() + "\u4e2a"));
            errorNums += error.get();
        }
        return errorNums;
    }
}

