/*
 * Decompiled with CFR 0.152.
 */
package com.aote.util.other;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.Base64;

public class Base64Utils {
    private static final int CACHE_SIZE = 1024;

    public static String decode(String base64) {
        return new String(Base64Utils.decodeBuffer(base64), StandardCharsets.UTF_8);
    }

    public static byte[] decodeBuffer(String base64) {
        Base64.Decoder decoder = Base64.getDecoder();
        return decoder.decode(base64.getBytes(StandardCharsets.UTF_8));
    }

    public static String encode(byte[] bytes) {
        return new String(Base64Utils.encodeBuffer(bytes), StandardCharsets.UTF_8);
    }

    public static byte[] encodeBuffer(byte[] bytes) {
        Base64.Encoder encoder = Base64.getEncoder();
        return encoder.encode(bytes);
    }

    public static String encodeFile(String filePath) throws Exception {
        byte[] bytes = Base64Utils.fileToByte(filePath);
        return Base64Utils.encode(bytes);
    }

    public static byte[] fileToByte(String filePath) throws Exception {
        byte[] data = new byte[]{};
        File file = new File(filePath);
        if (file.exists()) {
            FileInputStream in = new FileInputStream(file);
            ByteArrayOutputStream out = new ByteArrayOutputStream(2048);
            byte[] cache = new byte[1024];
            int nRead = 0;
            while ((nRead = in.read(cache)) != -1) {
                out.write(cache, 0, nRead);
                out.flush();
            }
            out.close();
            in.close();
            data = out.toByteArray();
        }
        return data;
    }

    public static void byteArrayToFile(byte[] bytes, String filePath) throws Exception {
        ByteArrayInputStream in = new ByteArrayInputStream(bytes);
        File destFile = new File(filePath);
        if (!destFile.getParentFile().exists()) {
            destFile.getParentFile().mkdirs();
        }
        destFile.createNewFile();
        FileOutputStream out = new FileOutputStream(destFile);
        byte[] cache = new byte[1024];
        int nRead = 0;
        while ((nRead = in.read(cache)) != -1) {
            ((OutputStream)out).write(cache, 0, nRead);
            out.flush();
        }
        ((OutputStream)out).close();
        ((InputStream)in).close();
    }
}

