/*
 * Decompiled with CFR 0.152.
 */
package com.aote.queryparams;

import com.aote.exception.FileNotFoundException;
import com.aote.queryparams.QueryParamsMapper;
import com.aote.queryparams.QueryTypeEnum;
import com.aote.rs.mapper.WebException;
import com.aote.util.ResourceHelper;
import com.aote.util.ResourceType;
import java.io.IOException;
import java.util.Iterator;
import org.apache.commons.lang3.StringUtils;
import org.json.JSONObject;
import org.springframework.stereotype.Component;

@Component
public class QueryParamsServer {
    public static String getValue(String queryParamsName, JSONObject params) throws Exception {
        JSONObject realQueryParamsMap;
        String path = QueryParamsMapper.getQueryParams(queryParamsName);
        if (path == null) {
            throw new RuntimeException("\u67e5\u8be2\u53c2\u6570\u672a\u627e\u5230: " + queryParamsName);
        }
        try {
            realQueryParamsMap = (JSONObject)ResourceHelper.getString(ResourceType.QUERY_PARAMS, queryParamsName, path);
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException(path + ".\u6587\u4ef6\u65e0\u914d\u7f6e");
        }
        catch (IOException io) {
            throw new RuntimeException(io);
        }
        Iterator iterator = params.keys();
        StringBuilder condition = new StringBuilder(" 1=1");
        while (iterator.hasNext()) {
            String key = (String)iterator.next();
            String value = String.valueOf(params.get(key));
            if (value.length() == 0 || value.equals("\u5168\u90e8")) continue;
            if (realQueryParamsMap.has(key)) {
                JSONObject queryParams = realQueryParamsMap.getJSONObject(key);
                QueryTypeEnum queryType = QueryTypeEnum.toType(queryParams.getString("queryType"));
                String realKey = queryParams.getString("key");
                switch (queryType) {
                    case EQUALS: 
                    case NO_EQUALS: 
                    case LESS_THAN: 
                    case LESS_THAN_EQUALS: 
                    case GREATER_THAN: 
                    case GREATER_THAN_EQUALS: {
                        condition.append(" AND ").append(realKey).append(" ").append(queryType.getValue()).append("'").append(value).append("'");
                        break;
                    }
                    case INNER_LIKE: {
                        condition.append(" AND ").append(realKey).append(" LIKE '%").append(value).append("%'");
                        break;
                    }
                    case LEFT_LIKE: {
                        condition.append(" AND ").append(realKey).append(" LIKE '%").append(value).append("'");
                        break;
                    }
                    case RIGHT_LIKE: {
                        condition.append(" AND ").append(realKey).append(" LIKE '").append(value).append("%'");
                        break;
                    }
                    case IN: {
                        condition.append(" AND ").append(realKey).append(" IN (").append(value).append(")");
                        break;
                    }
                    case NOT_IN: {
                        condition.append(" AND ").append(realKey).append(" NOT IN (").append(value).append(")");
                        break;
                    }
                    case BETWEEN: {
                        String[] values = StringUtils.split((String)value, (String)",");
                        condition.append(" AND ").append(realKey).append(" BETWEEN '").append(values[0]).append(" AND ").append(values[1]);
                    }
                }
                continue;
            }
            throw new WebException(500, "\u6587\u4ef6'" + path + "'\u7f3a\u5c11\u5b57\u6bb5'" + key + "'");
        }
        return condition.toString();
    }
}

