/*
 * Decompiled with CFR 0.152.
 */
package com.aote.module;

import com.aote.exception.FileNotFoundException;
import com.aote.logic.LogicMapper;
import com.aote.util.ResourceHelper;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.log4j.Logger;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;
import org.json.JSONArray;
import org.json.JSONObject;

public class ModuleMapper {
    static Logger log = Logger.getLogger(LogicMapper.class);
    private static Map<String, Map<String, String>> map;
    private static Map<String, Map<String, String>> subclassmap;

    public static String getAttr(String module, String attr) {
        if (map.containsKey(module)) {
            return map.get(module).get(attr);
        }
        return null;
    }

    public static Map<String, Map<String, String>> getSubClassMap() {
        return subclassmap;
    }

    public static Map<String, Map<String, String>> getMap() {
        return map;
    }

    private static void loadSubClassMap() {
        String strConfig;
        subclassmap = new HashMap<String, Map<String, String>>();
        if (ResourceHelper.class.getResourceAsStream("/subclass.json") == null) {
            log.debug((Object)"\u65e0subclass.json\u6587\u4ef6\uff0c\u7ee7\u627f\u5173\u7cfb\u6a21\u5757\u5316\u65e0");
            return;
        }
        try {
            strConfig = ResourceHelper.getString("subclass.json");
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException("subclass.json\u6587\u4ef6\u65e0\u914d\u7f6e");
        }
        catch (IOException io) {
            throw new RuntimeException(io);
        }
        JSONArray json = new JSONArray(strConfig);
        for (Object obj : json) {
            JSONObject jo = (JSONObject)obj;
            String name = jo.getString("module");
            HashMap<String, String> module = new HashMap<String, String>();
            module.put("name", name);
            subclassmap.put(name, module);
        }
    }

    private static void loadMap() {
        map = new HashMap<String, Map<String, String>>();
        InputStream module = LogicMapper.class.getClassLoader().getResourceAsStream("module.xml");
        try {
            if (module == null) {
                throw new RuntimeException("\u6a21\u5757\u5b9a\u4e49\u6587\u4ef6module.xml\u672a\u627e\u5230");
            }
            ModuleMapper.parseModule(module);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    private static void parseModule(InputStream input) throws Exception {
        SAXReader reader = new SAXReader();
        Document document = reader.read(input);
        Element root = document.getRootElement();
        String mode = root.attributeValue("mode");
        if (mode != null && mode.equals("debug")) {
            log.warn((Object)"\u68c0\u6d4b\u5230\u5df2\u5728module.xml\u4e2d\u5f00\u542f\u8c03\u8bd5\u6a21\u5f0f(mode='debug')\uff0c\u4e1a\u52a1\u8d44\u6e90\u61d2\u52a0\u8f7d\u4f18\u5316\u5df2\u5173\u95ed");
            log.warn((Object)"\u751f\u4ea7\u73af\u5883\u4e0b\u5efa\u8bae\u5173\u95ed\u8be5\u6a21\u5f0f\uff0c\u4ee5\u907f\u514d\u6bcf\u6b21\u8bbf\u95ee\u4e1a\u52a1\u8d44\u6e90\u6240\u5e26\u6765\u7684\u4e0d\u5fc5\u8981\u7684IO\u6d88\u8017");
            ResourceHelper.mode = "debug";
        } else {
            log.info((Object)"\u4e1a\u52a1\u8d44\u6e90\u61d2\u52a0\u8f7d\u4f18\u5316\u5df2\u5f00\u542f\uff0cLogic/SQL\u7f13\u5b58\u6210\u529f\uff0c\u53ef\u4ee5\u901a\u8fc7rs/logic/clear\u5f3a\u5236\u6e05\u7406\u7f13\u5b58");
        }
        Iterator it = root.elementIterator("module");
        while (it.hasNext()) {
            Element elm = (Element)it.next();
            String name = elm.attribute("name").getValue();
            String upload = elm.attributeValue("upload");
            String path = elm.attributeValue("path");
            HashMap<String, String> module = new HashMap<String, String>();
            module.put("name", name);
            module.put("upload", upload);
            module.put("path", path);
            map.put(name, module);
        }
    }

    static {
        ModuleMapper.loadMap();
        ModuleMapper.loadSubClassMap();
    }
}

