package com.aote.rs;

import com.aote.entity.EntityServer;
import com.aote.exception.ExceptionLogManage;
import com.aote.util.ExceptionHelper;
import com.aote.util.JsonHelper;
import com.aote.util.ParamFilter;
import com.aote.util.Util;
import com.aote.util.other.AESUtil;
import org.apache.log4j.Logger;
import org.json.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

import javax.annotation.PostConstruct;
import javax.inject.Singleton;
import javax.ws.rs.DELETE;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;

@Path("entity")
@Singleton
@Component
@Transactional
public class EntityService {
	static Logger log = Logger.getLogger(EntityService.class);

	@Autowired
	private EntityServer entityServer;

	@Autowired
	private ExceptionLogManage exceptionLogManage;

	@POST
	@Path("{entity}")
	// 保存实体
	public String xtSave(@PathParam("entity") String entityName, String values)
			throws Exception {
		try {
			return entityEncrypt(entityName, values);
		} catch (Exception ex) {
			log.error(ExceptionHelper.stackToString(ex));
			exceptionLogManage.writeError(ex,entityName);
			throw ex;
		}
	}

	@DELETE
	@Path("{entity}/{id}")
	// 删除实体
	public String txDelete(@PathParam("entity") String entityName,
						   @PathParam("id") String id) throws Exception {
		try {
			return entityServer.delete(entityName, id);
		} catch (Exception ex) {
			log.error(ExceptionHelper.stackToString(ex));
			exceptionLogManage.writeError(ex,entityName);
			throw ex;
		}
	}

	/**
	 * 封装entity加解密
	 * @param entityName 实体名
	 * @param param	请求参数
	 * @return
	 * @throws Exception
	 */
	private String entityEncrypt(String entityName, String param) throws Exception{
		JSONObject paramJson = new JSONObject(param);
		JSONObject configJson = JsonHelper.getConfig();
		//验证
		Util.checkEncry(paramJson, configJson);
		//如果不需要加密，进入default正常执行
		if (!paramJson.has("aoteEncrypt")) {
			paramJson.put("aoteEncrypt", "default");
		}
		//sql注入标志位
		boolean sqlInject=false;
		if(configJson.has("sqlInject")){
			sqlInject = configJson.getBoolean("sqlInject");
		}
		//根据解密方式进行解密
		switch (paramJson.getString("aoteEncrypt")) {
			case "AES":
				// 数据解密
				String data = paramJson.getString("data");
				String encryKey = configJson.getString("encryKey");
				String decryData = AESUtil.decrypt(data, encryKey);
				//验证参数是否合法
				if(sqlInject) {
					ParamFilter.checkSqlJsonStr(decryData);
				}
				return AESUtil.encrypt(entityServer.partialSave(entityName, decryData), encryKey);
			default:
				//验证参数是否合法
				if(sqlInject) {
					ParamFilter.checkSqlJsonStr(param);
				}
				log.debug("entityName:" + entityName + ", params:" + param);
				return entityServer.partialSave(entityName, param);
		}
	}

	@PostConstruct
	public void init() {
		entityServer.loadMetaData();
	}
}
