package com.aote.exception;

import com.aote.entity.EntityServer;
import com.aote.sql.SqlServer;
import com.aote.util.ExceptionHelper;
import org.apache.log4j.Logger;
import org.json.JSONArray;
import org.json.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

import javax.servlet.http.HttpServletRequest;
import java.text.SimpleDateFormat;
import java.util.Date;

/**
 * 异常日志记录管理
 */
@Component
@Transactional(rollbackFor = Exception.class, propagation = Propagation.REQUIRES_NEW)
public class ExceptionLogManage {
    private static Logger LOGGER = Logger.getLogger(ExceptionLogManage.class);

    @Autowired
    private EntityServer entityServer;

    @Autowired
    private SqlServer sqlServer;

    public void writeError(Exception e, String path) {
        HttpServletRequest request = ((ServletRequestAttributes)
                RequestContextHolder.getRequestAttributes()).getRequest();
        String serviceName = request.getContextPath();
        String errorInfo = ExceptionHelper.stackToString(e);
        errorInfo = errorInfo.replace("/'","/'/'");
        int causedByIndex = errorInfo.lastIndexOf("Caused by");
        String title;
        if(causedByIndex != -1){
            title = errorInfo.substring(causedByIndex,errorInfo.substring(causedByIndex).indexOf("at "));
        } else {
            title = e.getMessage();
        }
        //查询是否已经记录过日志
        JSONArray logs;
        try {
            if(path == null){
                logs = sqlServer.querySQL("SELECT id,f_times FROM t_log WHERE f_service = '"+ serviceName +"' " +
                        "and f_error_title = '" + title + "'");
            } else {
                logs = sqlServer.querySQL("SELECT id,f_times FROM t_log WHERE f_service = '"+ serviceName +"' " +
                        "and f_src = '"+ path +"' and f_error_title = '" + title + "'");
            }
        } catch (Exception exception) {
            LOGGER.error(exception);
            logs = new JSONArray();
        }
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String date = format.format(new Date());
        JSONObject params;
        if(logs.length() > 0){
            params = logs.getJSONObject(0);
            int times = params.getInt("f_times");
            int id = params.getInt("id");
            params.put("f_times",times + 1);
            params.put("f_last_update_time",date);
            params.put("id",id);
        } else {
            //精简报错堆栈内容
            errorInfo = getLogicErrorInfo(errorInfo);
            params = new JSONObject();
            params.put("f_service",serviceName);
            params.put("f_src",path);
            params.put("f_log_type","异常");
            params.put("f_error_title",title);
            params.put("f_error_msg",errorInfo);
            params.put("f_first_update_time",date);
            params.put("f_last_update_time",date);
            params.put("f_times",1);
        }
        try {
            entityServer.partialSave("t_log",params);
        } catch (Exception exception) {
            LOGGER.error(exception);
        }
    }
    private static String getLogicErrorInfo(String errorInfo){
        //Logic报错堆栈截取思路如下：
        //将堆栈分成两部分
        //主要部分：Logic异常报错时，会出现com.af.expression.ExpressionException异常，通过该关键词递归截取
        //结尾部分：截取Caused by，获取根堆栈信息
        StringBuilder builder = new StringBuilder("==================\n");
        appendLogicErrorInfo(builder,errorInfo);
        return builder.toString();
    }

    private static void appendLogicErrorInfo(StringBuilder result,String errorInfo){
        //堆栈内容
        int ignoreIndex = errorInfo.indexOf("com.af.expression.ExpressionException: ");
        if(ignoreIndex != -1){
            errorInfo = errorInfo.substring(ignoreIndex + 39);
            int ignoreIndexEnd = errorInfo.indexOf("at ");
            if(ignoreIndexEnd != -1){
                result.append(errorInfo, 0, ignoreIndexEnd).append("\n==================\n");
                errorInfo = errorInfo.substring(ignoreIndexEnd + 3);
                appendLogicErrorInfo(result, errorInfo);
            }
        } else {
            //截取结尾部分
            ignoreIndex = errorInfo.lastIndexOf("Caused by:");
            if(ignoreIndex != -1){
                result.append(errorInfo.substring(ignoreIndex));
            }
        }
    }
}
