package com.aote.exception;

import com.aote.entity.EntityServer;
import com.aote.sql.SqlServer;
import com.aote.util.ExceptionHelper;
import org.apache.log4j.Logger;
import org.json.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

import javax.servlet.http.HttpServletRequest;
import javax.transaction.Transactional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/**
 * 异常日志记录管理
 */
@Component
@Transactional
public class ExceptionLogManage {
    private static Logger LOGGER = Logger.getLogger(ExceptionLogManage.class);

    @Autowired
    private EntityServer entityServer;

    @Autowired
    private SqlServer sqlServer;

    public void writeError(Exception e, String path) {
        HttpServletRequest request = ((ServletRequestAttributes)
                RequestContextHolder.getRequestAttributes()).getRequest();
        String serviceName = request.getContextPath();
        String errorInfo = ExceptionHelper.stackToString(e);
        String regEx = "Caused by:(.*)";
        Pattern pat = Pattern.compile(regEx);
        Matcher mat = pat.matcher(errorInfo);
        boolean rs = mat.find();
        LOGGER.warn("Exception:" + e.getCause().getClass() +
                "," + e.getCause().getMessage());
        LOGGER.warn("found?" + rs);
        LOGGER.warn(mat.group(1));
        JSONObject params = new JSONObject();
        params.put("f_service",serviceName);
        params.put("f_src",path);
        params.put("f_log_type","异常");
        params.put("f_error_title",e.getMessage());
        params.put("f_error_msg",errorInfo);
        params.put("f_times",0);
        try {
            entityServer.partialSave("t_log",params);
        } catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}
