package com.aote.queryparams.enums;

import java.util.stream.Stream;

/**
 * 关联类型
 * @author Mr.river
 */
public enum JoinTypeEnum {
    //左外关联
    LEFT_OUT_JOIN("LEFT JOIN"),
    //右外关联
    RIGHT_OUT_JOIN("RIGHT JOIN"),
    //内关联
    INNER_JOIN("INNER JOIN");
    private final String value;

    JoinTypeEnum(String value) {
        this.value = value;
    }

    public static JoinTypeEnum toType(String value) {
        return Stream.of(JoinTypeEnum.values())
                .filter(p -> p.value.equals(value))
                .findAny()
                .orElse(null);
    }

    public static boolean is(String value){
        return toType(value) != null;
    }

    public String getValue(){
        return value;
    }
}
