package com.aote.queryparams.enums;

import java.util.stream.Stream;

/**
 * 表单类型
 * @author Mr.river
 */
public enum FormTypeEnum {
    //输入框
    INPUT("input"),
    //选择框
    SELECT("select"),
    //级联多个选择框
    SELECTS("selects"),
    //多选框
    CHECKBOX("checkbox"),
    //日期范围选择框
    RANGE_PICKER("rangePicker"),
    //年份选择框
    YEAR_PICKER("yearPicker"),
    //月份选择框
    MONTH_PICKER("monthPicker"),
    //星期选择框
    WEEK_PICKER("weekPicker"),
    //单日选择框
    DATE_PICKER("datePicker"),
    //级联选择框
    CASCADER("cascader"),
    //文本域
    TEXTAREA("textarea"),
    //文件
    FILE("file"),
    //图片
    IMAGE("image"),
    //地点搜索框
    ADDRESS_SEARCH("addressSearch"),
    //城市选择框
    CITY_SELECT("citySelect"),
    //人员选择框
    PERSON_SETTING("personSetting");

    private final String value;

    FormTypeEnum(String value) {
        this.value = value;
    }

    public static FormTypeEnum toType(String value) {
        return Stream.of(FormTypeEnum.values())
                .filter(p -> p.value.equals(value))
                .findAny()
                .orElse(null);
    }

    public static boolean is(String value){
        return toType(value) != null;
    }

    public String getValue(){
        return value;
    }
}
