package com.aote.columns;

import com.aote.exception.FileNotFoundException;
import com.aote.queryparams.QueryParamsMapper;
import com.aote.util.ResourceHelper;
import com.aote.util.ResourceType;
import org.apache.log4j.Logger;
import org.json.JSONArray;
import org.json.JSONObject;
import org.springframework.stereotype.Component;

import java.io.IOException;
import java.util.Objects;

@Component
public class ColumnsServer {
    private static final Logger LOGGER = Logger.getLogger(ColumnsServer.class);

    /**
     * 获取前端用于生成表格展示列和表单项的集合
     *
     * @param name columns文件名
     * @return 文件内容
     */
    public static JSONObject getValue(String name) throws Exception {
        return (JSONObject) ResourceHelper.getString(ResourceType.QUERY_PARAMS,name,null);
    }

    /**
     * 判断表单内容是否含有文件
     * @param arr 表单配置
     * @return 是否含有
     */
    public static boolean hasFile(JSONArray arr) throws Exception {
        for (Object o : arr) {
           if (Objects.equals(((JSONObject) o).optString("type"), "image") || Objects.equals(((JSONObject) o).optString("type"), "image")){
               return  true;
           }
        }
        return false;
    }

    /**
     * 判断表单内容是否含有文件
     * @param name columns文件名
     * @return 是否含有
     */
    public static boolean hasFile(String name) throws Exception {
        JSONArray arr = ((JSONObject) ResourceHelper.getString(ResourceType.QUERY_PARAMS,name,null)).getJSONArray("formJson");
        for (Object o : arr) {
           if (Objects.equals(((JSONObject) o).optString("type"), "image") || Objects.equals(((JSONObject) o).optString("type"), "image")){
               return  true;
           }
        }
        return false;
    }

}
