/*
 * Decompiled with CFR 0.152.
 */
package com.aote.rs;

import com.aote.ThreadResource;
import com.aote.exception.FileNotFoundException;
import com.aote.rs.mapper.WebException;
import com.aote.util.ResourceHelper;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import javax.inject.Singleton;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import org.json.JSONObject;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Path(value="vue")
@Singleton
@Component
public class VueService {
    @GET
    @Transactional
    @Path(value="{vue}")
    public String getVueConfig(@PathParam(value="vue") String vueName) throws Exception {
        String dir = ThreadResource.ComponentDir.get();
        if (dir == null) {
            throw new WebException(704, "\u7528\u6237\u6ca1\u6709\u7279\u6b8a\u76ee\u5f55\uff01");
        }
        String path = dir + "/vues/" + vueName;
        try {
            return ResourceHelper.getString(path);
        }
        catch (FileNotFoundException e) {
            throw new WebException(704, "\u6587\u4ef6\u4e0d\u5b58\u5728\uff1a" + e.getPath());
        }
    }

    @GET
    @Transactional
    public String getPhoneVueConfig() throws Exception {
        JSONObject jsons = new JSONObject();
        String dir = ThreadResource.ComponentDir.get();
        if (dir == null || "".equals(dir)) {
            throw new WebException(704, "\u7528\u6237\u6ca1\u6709\u7279\u6b8a\u76ee\u5f55\uff01");
        }
        try {
            File[] files;
            String path = this.getClass().getClassLoader().getResource(dir + "/phonevues/").getPath();
            for (File f : files = new File(path).listFiles()) {
                String str;
                String fileName = f.getName();
                StringBuffer strbuffer = new StringBuffer();
                FileInputStream fis = new FileInputStream(f);
                InputStreamReader inputStreamReader = new InputStreamReader((InputStream)fis, "UTF-8");
                BufferedReader in = new BufferedReader(inputStreamReader);
                while ((str = in.readLine()) != null) {
                    strbuffer.append(str);
                }
                in.close();
                JSONObject json = new JSONObject(strbuffer.toString().trim());
                jsons.put(fileName.substring(0, fileName.indexOf(".")), (Object)json);
            }
            return jsons.toString();
        }
        catch (FileNotFoundException e) {
            throw new WebException(704, "\u6587\u4ef6\u4e0d\u5b58\u5728: " + e.getPath());
        }
    }
}

